<?php
/**
 *	@package		Sendinblue
 *	@subpackage		sendinblue.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');
JHtml::_('behavior.tabstate');

// Set the component css/js
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_sendinblue/assets/css/site.css');
$document->addScript('components/com_sendinblue/assets/js/site.js');

// Require helper files
JLoader::register('SendinblueHelper', __DIR__ . '/helpers/sendinblue.php'); 
JLoader::register('SendinblueHelperRoute', __DIR__ . '/helpers/route.php'); 

// Triger the Global Site Event
SendinblueHelper::globalEvent($document);

// Get an instance of the controller prefixed by Sendinblue
$controller = JControllerLegacy::getInstance('Sendinblue');

// Perform the request task
$controller->execute(JFactory::getApplication()->input->get('task'));

// Redirect if set by the controller
$controller->redirect();
