<?php
/**
 * @package    sponsorswall
 * @subpackage models
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

jimport('joomla.application.component.modellist');

class SponsorswallModelSponsorswall extends JModelItem
{

    public function getItem()
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Default var's
        $app    = JFactory::getApplication();
        $jinput = $app->input;
        $menu   = $app->getMenu();
        $active = $menu->getActive();

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Hole die aktuelle Kategorie-ID
        $id = 0;
        $id = (int)$active->query['cid'];

        if ($id == 0) return array();

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Prüfen ob die ausgewählte Kategorie eine LEVEL 1 Kategorie ist
        $db         = JFactory::getDbo();
        $conditions = array(
            $db->quoteName('id') . ' = ' . $db->quote($id),
            $db->quoteName('level') . ' = ' . $db->quote(1),
            $db->quoteName('extension') . ' = ' . $db->quote('com_sponsorswall'),
        );

        $query = $db->getQuery(true);
        $query->select(array('id, level, lft, rgt'))
            ->from($db->quoteName('#__categories'))
            ->where($conditions);
        $db->setQuery($query);
        $db->execute();
        $count           = $db->getNumRows();
        $parent_category = $db->loadAssoc();

        if ($count < 1) return array(
            'error' => 'true',
            'text' => 'Keine Level 1 Kategorie in der Menükonfiguration ausgewählt'
        );
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Kategorien zur passenden Elternkategorie laden
        $conditions = array(
            $db->quoteName('c.parent_id') . ' = ' . $db->quote($parent_category['id']),
            $db->quoteName('c.published') . ' = ' . $db->quote(1),
            $db->quoteName('c.level') . ' = ' . $db->quote(2),
        );

        $query = $db->getQuery(true);
        $query->select('c.id, c.title, c.description')
            ->from('#__categories AS c');

        //Joining über
        $query->select(array(
            $db->quoteName('cw.col_xs'),
            $db->quoteName('cw.col_sm'),
            $db->quoteName('cw.col_md'),
            $db->quoteName('cw.col_lg'),
        ))
            ->join('LEFT', '#__sponsorswall_columnwidths AS cw ON c.id = cw.cid');

        //Where
        $query->where($conditions);

        $db->setQuery($query);
        $db->execute();
        $count      = $db->getNumRows();
        $categories = $db->loadAssocList();

        if ($count < 1) return array();
        /*
                [0] => Array
                (
                    [id] => 24
                    [title] => Hauptsponsoren
                )
         */
        $categories_to_fill = array();
        foreach ($categories as $category) {
            $categories_to_fill[] = $category['id'];
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Die Sponsoren zu den Kateogieren laden
        $nullDate = $db->quote($db->getNullDate());
        $nowDate  = $db->quote(JFactory::getDate()->toSql());

        $conditions = array(
            $db->quoteName('s.cid') . ' IN (' . implode(',', $categories_to_fill) . ') ',
            $db->quoteName('s.state') . ' = ' . $db->quote(1),
        );

        $query = $db->getQuery(true);
        $query->select('s.*')
            ->from('#__sponsorswall_sponsors AS s');

        //Where
        $query->where($conditions);
        $query->where('(s.publish_up = ' . $nullDate . ' OR s.publish_up <= ' . $nowDate . ')');
        $query->where('(s.publish_down = ' . $nullDate . ' OR s.publish_down >= ' . $nowDate . ')');

        $db->setQuery($query);
        $db->execute();
        $count    = $db->getNumRows();
        $sponsors = $db->loadAssocList();

        if ($count < 1) return array();

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Die Sponsoren zu den Kateogieren hinzufügen
        //TODO: Optimize foreach
        foreach ($categories as $cat_key => $category) {
            foreach ($sponsors as $sponsor_key => $sponsor) {
                if ($sponsor['cid'] == $category['id']) {
                    $categories[$cat_key]['sponsors'][] = $sponsor;
                    unset($sponsors[$sponsor_key]);
                }
            }
        }

        return $categories;
    }

    public function getRedirect($target)
    {
        $target = (int)$target;

        $db = JFactory::getDbo();

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Prüfen ob es den Sponsor mit dieser ID gibt und target url holen
        $conditions = array(
            $db->quoteName('id') . ' = ' . $db->quote($target),
        );

        $query = $db->getQuery(true);
        $query->select('link')
            ->from($db->quoteName('#__sponsorswall_sponsors'))
            ->where($conditions);
        $db->setQuery($query);
        $db->execute();
        $count  = $db->getNumRows();
        $result = $db->loadAssoc();

        if ($count < 1) return array();

        $this->click($target);

        return $result;
    }

    /**
     * Clicks the URL, incrementing the counter
     *
     * @param $target
     *
     * @return  void
     *
     * @since   1.5
     */
    public function click($target)
    {
        $target = (int)$target;

        // Update click count
        $db    = $this->getDbo();
        $query = $db->getQuery(true)
            ->update('#__sponsorswall_sponsors')
            ->set('clicks = (clicks + 1)')
            ->where('id = ' . (int)$target);
        $db->setQuery($query);

        try {
            $db->execute();
            return true;
        } catch (RuntimeException $e) {
            JError::raiseError(500, $e->getMessage());
        }
    }
}