<?php
/**
 * @package    sponsorswall
 * @subpackage views
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Get component params and define default's
$params                     = JComponentHelper::getParams('com_sponsorswall');
$param_bootstrap_version    = $params->get('bootstrap_version');

$class_thumbnail = 'thumbnail';
$class_img		 = 'img-responsive';

switch ($params->get('bootstrap_version')) {
    case 2:
        $col_prefix_xs = 'span';
        $col_prefix_sm = '';    //Not used for Bootstrap 2.*
        $col_prefix_md = '';    //Not used for Bootstrap 2.*
        $col_prefix_lg = '';    //Not used for Bootstrap 2.*
        break;
    case 3:
    default:
        $col_prefix_xs = 'col-xs-';
        $col_prefix_sm = 'col-sm-';
        $col_prefix_md = 'col-md-';
        $col_prefix_lg = 'col-lg-';
        break;
	case 4:
		$col_prefix_xs = 'col-';
        $col_prefix_sm = 'col-sm-';
        $col_prefix_md = 'col-md-';
        $col_prefix_lg = 'col-lg-';
		$class_thumbnail = 'img-thumbnail';
		$class_img		 = 'img-fluid';
		break;
}

$default_col_xs = ($params->get('col_xs') > 0) ? $col_prefix_xs . $params->get('col_xs') : $col_prefix_xs . 12;
$default_col_sm = ($params->get('col_sm') > 0) ? $col_prefix_sm . $params->get('col_sm') : $col_prefix_sm . 4;
$default_col_md = ($params->get('col_md') > 0) ? $col_prefix_md . $params->get('col_md') : $col_prefix_md . 6;
$default_col_lg = ($params->get('col_lg') > 0) ? $col_prefix_lg . $params->get('col_lg') : $col_prefix_lg . 6;

/*
|-----------------------------------------------------------------------------------------------------------------------
| HTML OUTPUT BELOW
|-----------------------------------------------------------------------------------------------------------------------
*/


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Display items if there are items to display
if ($this->items) :
    ?>
    <div id="agmedia_sponsorswall">
        <?php
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Loop through categories
        foreach ($this->items as $category) :
            ////////////////////////////////////////////////////////////////////////////////////////////////
            // If category is empty (no sponsors in category), then skip this category
            if (empty($category['sponsors'])) continue;

            ////////////////////////////////////////////////////////////////////////////////////////////////
            // Define the size's for this category. Check if there are override values available
            $col_size_xs = ($category['col_xs'] > 0) ? $col_prefix_xs . $category['col_xs'] : $default_col_xs;
            $col_size_sm = ($category['col_sm'] > 0) ? $col_prefix_sm . $category['col_sm'] : $default_col_sm;
            $col_size_md = ($category['col_md'] > 0) ? $col_prefix_md . $category['col_md'] : $default_col_md;
            $col_size_lg = ($category['col_lg'] > 0) ? $col_prefix_lg . $category['col_lg'] : $default_col_lg;


            switch ($params->get('bootstrap_version')) {
                case 2:
                    $col_class = $col_size_xs;
                    $row_class = 'row-fluid bs2';
                    break;
                case 3:
                default:
                    $col_class = $col_size_xs . ' ' . $col_size_sm . ' ' . $col_size_md . ' ' . $col_size_lg;
                    $row_class = 'row';
                    break;

            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////
            // HTML for category
            ?>
            <h2><?php echo $category['title']; ?></h2>
            <?php 
            if(!empty($category['description']))
            {
            	?>
            	<p><?php echo $category['description']; ?></p>
            	<?php
            }	
            ?>
            
            <div class="<?php echo $row_class; ?> row-eq-height">
                <?php foreach ($category['sponsors'] as $sponsor) :
                    ////////////////////////////////////////////////////////////////////////////////
                    // HTML for sponsor
					
					switch($sponsor['link_target']) {
						case 1:
						default:
							$link_target = '_blank';
							break;
							
						case 2:
							$link_target = '_self';
							break;
					}
					
					$link_href = (!empty($sponsor['link'])) ? JRoute::_('index.php?option=com_sponsorswall&task=link&target=' . $sponsor['id']) : '';
                    ?>
                    <div class="<?php echo $col_class; ?>">
                    	<?php if(!empty($link_href)) : ?>
                         <a class="<?php echo $class_thumbnail; ?>" target="<?php echo $link_target; ?>"
                           href="<?php echo $link_href; ?>">
                            <img class="<?php echo $class_img; ?>" alt=""
                                 src="<?php echo JURI::root(true) . DS . $sponsor['image']; ?>"/>
                        </a>                   	
                    	<?php else: ?>
                         <a class="<?php echo $class_thumbnail; ?>">
                            <img class="<?php echo $class_img; ?>" alt=""
                                 src="<?php echo JURI::root(true) . DS . $sponsor['image']; ?>"/>
                        </a>
                    	<?php endif; ?>

                    </div> <!-- col-* / end -->
                <?php endforeach; ?>
            </div> <!-- row / end -->
            <?php
        endforeach;
        
        if($params->get('show_link_agmedia') == 0) {
			//Show nothing
		}
		else 
		{				
            echo "<p style='text-align: right; display: block !important; font-size:12px;'>".JText::_('AGMEDIA_COPYRIGHT')."</p>";
        }
        ?>
    </div><!-- #agmedia_sponsorswall / end -->
    <?php
endif;
?>