<?php
/**
 * @package    AGMedia Library
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Apr-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

/**
 * AgmLibAdminBackend library.
 * @since 1.0.0
 */
class AgmLibAdminBackend
{

	protected static $loaded = false;

    public function __construct() {
		if(!self::loaded) {
			self::$loaded = true;
			self::load();
		}
    }

    public static function load() {
        $document = JFactory::getDocument();
        $document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/AgmLibAdminBackend.css');
	    $document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/components/AgmLibAlert.css');
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/components/AgmLibBackgrounds.css');
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/components/AgmLibBorders.css');
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/components/AgmLibFont.css');
	    $document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/components/AgmLibModal.css');
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/components/AgmLibPaddingMargin.css');
	    $document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/components/AgmLibPanel.css');
	    $document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/components/AgmLibTabs.css');
	    $document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/bootstrap-panels.css');
        //$document->addStyleSheet('http://fonts.googleapis.com/css?family=Open+Sans');
	    $document->addStyleSheet('https://fonts.googleapis.com/css?family=Roboto:400,500');
        
       

	    //FontAwesome
	    AgmLibScripts::loadFontawesome();

		JHtml::_('jquery.framework');
        //Backend JS
        $document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/js/jquery.AgmBackend.js');
    }
  
}