<?php
/**
 * @package    AGMedia Library
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Apr-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

/**
 * AgmLibAdminDatatables library.
 * @since 1.0.0
 */
class AgmLibAdminDatatables
{
      public $_debug = false;
      
      private $_defined = 'AGM_DATATABLES';
      private $_init = false; //true if function init() was called
      private $_output = '';
      private $_table_id = '';
      private $_document;
	  private $_bootstrap = 2;

      //DataTable Options      
      private $_order = '';
      private $_search = 'true';
      private $_orderable = array('enabled' => "true", 'targets' => '_all');
      private $_searchable = array('enabled' => "true", 'targets' => '_all');
      private $_pagination = "false";

      

   public function __construct($table_id) {        
      $this->_document = JFactory::getDocument();
      $this->_table_id = $table_id;
          
      //Check if we need to load CSS & JS files
      if(!defined($this->_defined)) {
        $this->_document->addStyleSheet(JURI::root( true ) . '/libraries/agmlib/assets/css/AgmLibDataTables.css');
        $this->_document->addScript(JURI::root( true ) . '/libraries/agmlib/assets/js/jquery.AgmDataTables.min.js');
        $this->_document->addScript(JURI::root( true ) . '/libraries/agmlib/assets/js/jquery.AgmDataTables.standards.js');
        
        define($this->_defined, true);
      }   
   }
   
   public function order($column_id, $order_direction = 'asc') {
      $this->_order = '"order": ['.$column_id.', "'.$order_direction.'"]';
   }
   
   public function search($enabled) {
      $this->_search= $enabled;
   }

	public function orderable($enabled = true, $targets = '_all') {
      $this->_orderable['enabled'] = (string) $enabled;
      $this->_orderable['targets'] = $targets;
   }
   
   public function searchable ($enabled = true, $targets = '_all') {
      $this->_searchable['enabled'] = (string) $enabled;
      $this->_searchable['targets'] = $targets;
   }
   
   public function pagination($enabled = true) {
      $this->_pagination = (string) $enabled;
   }
	
	//Deprecated
	public function bootstrap3($enabled = true) {
		$this->_bootstrap = 3;
	}
	
	public function bootstrap($version = 2) {
		if($version > 1 && $version < 5) {
			$this->_bootstrap = $version;
		}
		
	}
   
   public function init() {
      //Orderable Targets
      $orderable_targets = '';
      if(is_string($this->_orderable['targets'])) {
         $orderable_targets = '"'.$this->_orderable['targets'].'"';
      }
      
      if(is_array($this->_orderable['targets'])) {
         $orderable_targets = '['.implode(", ", $this->_orderable['targets']).']';
      }
      
      //Seachable Targets
      $searchable_targets = '';
      if(is_string($this->_searchable['targets'])) {
         $searchable_targets = '"'.$this->_searchable['targets'].'"';
      }
      
      if(is_array($this->_searchable['targets'])) {
         $searchable_targets = '['.implode(", ", $this->_searchable['targets']).']';
      }
      
      //Change dom if needed
      //$dom = '"dom": "<\"dt-top-row\"fl<\"clearfix\">>r<\"dt-wrapper\"t><\"dt-row dt-bottom-row\"<\"row-fluid\"<\"col-xs-6\"i><\"col-xs-6 text-right\"p>>>",';
      $dom = '"dom": "<\"dt-top-row\"fl<\"clearfix\">>r<\"dt-wrapper\"t><\"dt-row dt-bottom-row\"ip>",';
      if($this->_search == 'false') {
         $dom = '"dom": "<\"dt-top-row\"l<\"clearfix\">>r<\"dt-wrapper\"t><\"dt-row dt-bottom-row\"ip>",';
      }  
      if($this->_pagination == 'false') {
         $dom = '"dom": "<\"dt-top-row\"f<\"clearfix\">>r<\"dt-wrapper\"t><\"dt-row dt-bottom-row\"ip>",';
      }      
      if($this->_pagination == 'false' && $this->_search == 'false') {
         $dom = '"dom": "r<\"dt-wrapper\"t><\"dt-row dt-bottom-row\"ip>",';
      }

	   //Which Bootstrap Version
	   switch($this->_bootstrap) {
		   case 2:
		   default:
			   $paging_type = 'bootstrap';
			   break;
		   case 3:
		   case 4: //TODO: Prüfen ob es ein Update für Datatables gibt das Bootstrap 4 kann
			   $paging_type = 'bootstrap3';
			   break;
	   }
   
      //Start DataTable markup
      $this->_output .= 'jQuery( document ).ready(function($) {
         $("#'.$this->_table_id.'").DataTable({
            "initComplete": function() { 
               agmDataTableAfterInit("'.$this->_table_id.'");   
            },
            "columnDefs": [
               { "orderable": '.$this->_orderable["enabled"].', "targets": '.$orderable_targets.' },
               { "searchable": '.$this->_searchable["enabled"].', "targets": '.$searchable_targets.' }
            ], 
            "paging": '.$this->_pagination.',
            "pagingType": "'.$paging_type.'",
            "searching": '.$this->_search.',
            '.$dom.'
            '.$this->_order.',
            
         })//Close AgmDataTable()
      });//Close jQuery.ready()';
      
      $this->_document->addScriptDeclaration($this->_output);
      
      $this->_init = true;
      
      return true;
   }
}