<?php
/**
 * @package    AGMedia Library
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Apr-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

/**
 * AgmLibAdminInfoPanel library.
 * @since 1.0.6
 */
class AgmLibAdminInfopanel
{
	public static function render($component) {
		AgmLibScripts::loadFontawesome();
		
		$db     = JFactory::getDbo();
		
		// Get component version
		$query  = $db->getQuery(true);
		$query ->select($db->qn(array('name', 'manifest_cache', 'type')))
		       ->from($db->qn('#__extensions'))
		       ->where($db->qn('type') . ' = ' . $db->q('component'))	
		       ->where($db->qn('element') . ' = ' . $db->q($component));	
		$db->setQuery($query);
		$result = $db->loadAssoc();
		
		$component_version = '';
		if(!empty($result['manifest_cache'])) {
		    $decode = json_decode($result['manifest_cache']);
			$component_version = $decode->version;
		}
		
		$output = '';
		
		$output .= '<div class="agm-infopanel">';
		$output .= '	<div class="panel-heading">';
		$output .= '		Versionsinformationen';
		$output .= '	</div>';
		$output .= '	<div class="panel-body agm-pa-0">';
		$output .= '		<table class="table table-striped agm-ma-0">
								<tr>
									<td>Komponente:</td>
									<td>'.$component_version.'</td>
								</tr>';
		
		if(AgmLibValidation::getValidationStatus($component) === true && $component == 'com_volleyimport') {
			$pro = new AgmLibDownloader($component);
			$pro_update_available = $pro->checkUpdateAvailable();
			
			$output .= '
								<tr>
									<td>Pro Erweiterung:</td>
									<td>
										'.$pro->getVersion();
										
			if($pro_update_available) {
				$output .= '			<a href="'.JRoute::_('index.php?option=com_volleyimport&task=pro.update').'" class="btn btn-small" title="Update verfügbar"><i class="fal fa-download"></i></a>';				
			}										
										
			$output .= '			</td>
								</tr>				
			';			
		}
		
		if($component == 'com_volleyimport' && defined('AGMEDIA_VOLLEYIMPORT_PLUGIN_VERSION')) {
			// Get component version
			$query  = $db->getQuery(true);
			$query ->select($db->qn(array('name', 'manifest_cache', 'type')))
			       ->from($db->qn('#__extensions'))
			       ->where($db->qn('type') . ' = ' . $db->q('plugin'))	
			       ->where($db->qn('element') . ' = ' . $db->q('volleyimport'));	
			$db->setQuery($query);
			$result = $db->loadAssoc();
			
			$component_version = '';
			if(!empty($result['manifest_cache'])) {
			    $decode = json_decode($result['manifest_cache']);
				$plugin_version = $decode->version;
			}
			
			$output .= '
								<tr>
									<td>Plugin volleyImport:</td>
									<td>'.$plugin_version.'</td>
								</tr>				
			';			
		}
								
		if(AGMLIB_INCLUDED == '1') {
			$output .= '
								<tr>
									<td>AGMedia Library:</td>
									<td>'.AgmLibBase::version().'</td>
								</tr>				
			';
		}
							
		$output .= '		</table>
					';
		$output .= '	</div>';
		$output .= '</div>';
		
		return $output;
	}	
}