<?php
/**
 * @package    AGMedia Library
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Apr-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

/**
 * AgmLibAdminSidebar library.
 * @since 1.0.0
 */
class AgmLibAdminSidebar
{
   protected static $menu = array();
   protected static $default_view = '';
   
   /**
     * Method to add a menu_header item to submenu.
     *
     * @param   string  $name    Name of the menu item.
     * @param   string  $type    TYPE of the menu item
     * @param   bool    $active  True if the item is active, false otherwise.
     *
     * @return  void
     *
     * @since   3.0
     */
   public static function addHeader($name)
   {
      static::$menu[] = array('type' => 'header', 'name' => $name);
   }   
   
   /**
     * Method to add a menu_divider item to submenu.
     *
     * @param   string  $name    Name of the menu item.
     * @param   string  $type    TYPE of the menu item
     * @param   bool    $active  True if the item is active, false otherwise.
     *
     * @return  void
     *
     * @since   3.0
     */
   public static function addDivider()
   {
      static::$menu[] = array('type' => 'divider');
   }   
   
   /**
     * Method to add a menu_entry item to submenu.
     *
     * @param   string  $name    Name of the menu item.
     * @param   string  $type    TYPE of the menu item
     * @param   bool    $active  True if the item is active, false otherwise.
     *
     * @return  void
     *
     * @since   3.0
     */
   public static function addLink($name, $component, $view, $icon = '') 
   {
      $href = JRoute::_('index.php?option='.$component.'&view='.$view);
      
      $input_view = JFactory::getApplication()->input->get->get('view');
      
      if(empty($input_view)) {
    	if(!empty(static::$default_view)) {
    		$input_view = static::$default_view;
    	}	
      }
   
      $active = ($input_view == $view) ? 'class="active"' : '';
      $icon = (!empty($icon)) ? '<i class="fa '.$icon.'"></i>' : '';
   
      static::$menu[] = array('type' => 'link',
                             'name' => $name,
                             'href' => $href,
                             'icon' => $icon,
                             'active' => $active);
   }   
   
   public static function addSpecialLink($name, $option, $view, $extension, $icon = '') 
   {
      $href = JRoute::_('index.php?option='.$option.'&view='.$view.'&extension='.$extension);
   
      $active = (JFactory::getApplication()->input->get->get('view') == $view) ? 'class="active"' : '';
      $icon = (!empty($icon)) ? '<i class="fa '.$icon.'"></i>' : '';
   
      static::$menu[] = array('type' => 'link',
         'name' => $name,
         'href' => $href,
         'icon' => $icon,
         'active' => $active);
   }

   public static function render($component) 
   {
       AgmLibAdminBackend::load();
      $output  = '<div class="sidebar-nav">';
      $output .= '<div class="well" style="padding: 8px 0;">';
      $output .= '<ul class="nav nav-list">';
   
      if(!empty(static::$menu)) {
          foreach(static::$menu as $entry) {
              switch($entry['type']) {
                  case 'header':
                      $output .= '<li class="nav-header">'.$entry['name'].'</li>';
                      break;
                  case 'divider':
                      $output .= '<li class="divider"></li>';
                      break;
                  case 'link':
                      //$output .= '<li '.$entry['active'].'><a href="'.$entry['href'].'">'.$entry['icon'].'&nbsp;'.$entry['name'].'</a></li>';
                      $output .= '<li '.$entry['active'].'><a href="'.$entry['href'].'">'.$entry['name'].'</a></li>';
                      break;
              }
          }
      }
   
      $output .= '</ul></div></div>';
   
      return $output;
   
   }

   public static function setDefaultView($name)
   {	
		if(!empty($name)) {
    		static::$default_view = $name;
		}
   }   
   
}//class
?>