<?php
/**
 * @package    AgmLib
 * @subpackage Array
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on 26-Mar-2015
 * @license    GNU/GPL
 */

//-- No direct access
defined('_JEXEC') || die('=;)');


/**
 * AgmLib library.
 *
 */
class AgmLibArray
{
    /**
     *
     *  $sorted = sortArrayByFields(
     *      $data,
     *      array(
     *          'jahrgang' => SORT_DESC,
     *          'nachname' => array(SORT_ASC, SORT_STRING)
     *      )
     *  );
     */
    public static function sortArrayByFields($arr, $fields)
    {
        $sortFields = array();
        $args       = array();

        foreach ($arr as $key => $row) {
            foreach ($fields as $field => $order) {
                $sortFields[$field][$key] = $row[$field];
            }
        }

        foreach ($fields as $field => $order) {
            $args[] = $sortFields[$field];

            if (is_array($order)) {
                foreach ($order as $pt) {
                    $args[$pt];
                }
            } else {
                $args[] = $order;
            }
        }

        $args[] = &$arr;

        call_user_func_array('array_multisort', $args);

        return $arr;
    }
	
	
	public static function sort_multidim_array_by_key($array_to_search_in, $order_by_key, $sort_dir = SORT_ASC) {

		if(empty($array_to_search_in)) return -1;
		if(empty($order_by_key)) return -2;

		$sortArray = array();

		foreach($array_to_search_in as $element){
			foreach($element as $key=>$value){
				if(!isset($sortArray[$key])){
					$sortArray[$key] = array();
				}
				$sortArray[$key][] = $value;
			}
		}


		array_multisort($sortArray[$order_by_key],$sort_dir,$array_to_search_in);

		return $array_to_search_in;
	}

	/**
	 * Multi-array search
	 *
	 * @param array $array      Array to search in
	 * @param array $search     Array mit Bedingungen z.B. array('Manufacturer' => 'Apple', 'Model' => 'iPhone 6')
	 * @return array
	 */
	public static function multi_array_search($array, $search)
	{

		// Create the result array
		$result = array();

		// Iterate over each array element
		foreach ($array as $key => $value)
		{

			// Iterate over each search condition
			foreach ($search as $k => $v)
			{

				// If the array element does not meet the search condition then continue to the next element
				if (!isset($value[$k]) || $value[$k] != $v)
				{
					continue 2;
				}

			}

			// Add the array element's key to the result array
			$result[] = $key;

		}

		// Return the result array
		return $result;

	}






   /**
     * PHP Function array_filter for Multidimensional array's
     *
     * @param  array   $array       The array to be filtered.
     * @return array                The filtered array
     */
   public static function array_filter_multidim($array) 
   { 
      foreach ($array as &$value) 
      { 
         if (is_array($value)) 
         { 
            $value = self::array_filter_multidim($value); 
         } 
      } 
     
      return array_filter($array); 
   } 
   
   /**
     * PHP Function converToArray to convert Multidimensional array's with possible objects to real arrays
     *
     * @param  array   $array       The array to be filtered.
     * @return array                The filtered array
     */
   public static function convertToArray($object) {
      $array = json_decode(json_encode($object), true);
      
      return $array;
      
      /*$aTemp_array = (array) $array;
      foreach($aTemp_array as $nKey => $aChild) {
         
      }*/
   }
   
   /**
     * PHP Function searchInMultidimArray durchsucht ein Multidimensionales Array
     *
     * @param  string   $value_to_search_for   Wert nach dem gesucht wird
     * @param  string   $key_to_search_in      Welcher key wird durchsucht
     * @param  array    $array                 Das zu durchsuchende Array
     * @param  bool     $multiple              Wird ein Ergebnis erwartet oder mehrere
     * @return          Key für einen Wert, Array mit Keys für multiple
     */
   public static function searchInMultidimArray($value_to_search_for, $key_to_search_in, $array, $multiple = false) {
      if(is_array($array)) {
         if($multiple) {
            $result = array_keys(array_column($array, $key_to_search_in), $value_to_search_for);
         } else {
         	if(empty($key_to_search_in)) {
	            $search_result = array_search($value_to_search_for, $array);
            } else {
	            $search_result = array_search($value_to_search_for, array_column($array, $key_to_search_in));
            }


	         if($search_result !== false) {
				$result = $search_result; //Ergebnis zurückmelden
			} else {
				$result = -2; //Nichts gefunden
			}
         }
      } else {
         $result = -1; //No Array given
      }
      
      return $result;
   }
}//class
?>