jQuery( document ).ready(function() {
   //setDatatableClasses();
});

/*
 * SET DATATABLE DEFAULTS
 */
jQuery.extend( jQuery.fn.dataTable.defaults, {
    /*"dom": '<"datatable_tools"f<"clr">>rt',*/
    //"dom": '<"dt-top-row"lf>r<"dt-wrapper"t><"dt-row dt-bottom-row"<"row"<"col-sm-6"i><"col-sm-6 text-right"p>>',
    "dom": '<"dt-top-row"fl<"clearfix">>r<"dt-wrapper"t><"dt-row dt-bottom-row"<"row-fluid"<"col-xs-6"i><"col-xs-6 text-right"p>>>',
    "pagingType": "bootstrap",
    "language": {
        "lengthMenu": "_MENU_",//"Display _MENU_ records per page",
        "zeroRecords": "Keinen passenden Eintrag gefunden",
        "info": "Seite _PAGE_ von _PAGES_",
        "infoEmpty": "Keine Einträge verfügbar",
        "infoFiltered": "(_MAX_ Einträge durchsucht)",
        "search": "Suche",
        "paginate": {
            "first": "Erste",
            "next": "Nächste",
            "previous": "Vorherige",
            "last": "Letzte"
        }
    }
} );


function agmDataTableAfterInit(table_id) {
    //Generate Top-Row
    var agm_datatable = jQuery("#" + table_id);
    var agm_datatable_object = agm_datatable.DataTable();
    var agm_datatable_id = table_id;

    var isBootstrap3 = false;
    var isBootstrap4 = false;
    if(agm_datatable.hasClass('bootstrap3')) {
        isBootstrap3 = true;
    } else if(agm_datatable.hasClass('bootstrap4')) {
    	isBootstrap4 = true;
    }


    /***************************************************
     * SUCHE
     **************************************************/
    var agm_datatable_filter = agm_datatable.parent().parent().find('#'+ agm_datatable_id + '_filter');

    if(isBootstrap3) {
        agm_datatable_filter.html('<div class="input-group">\
                <span class="input-group-addon"><span class="glyphicon glyphicon-search" aria-hidden="true"></span></span>\
                <input type="text" class="form-control" placeholder="Suche" >\
            </div>');
    } else if(isBootstrap4) {
    	console.log("bs4");
        agm_datatable_filter.html('<div class="input-group">\
			  <div class="input-group-prepend">\
			    <span class="input-group-text"><i class="far fa-search"></i></span>\
			  </div>\
			  <input type="text" class="form-control" placeholder="Suche" >\
			</div>');
    } else {
        agm_datatable_filter.html('<div class="input-prepend">\
            <span class="add-on"><i class="icon-search"></i></span>\
            <input class="" id="" type="text" placeholder="Suche" >\
            </div>');
    }


    agm_datatable_filter.find('input').keyup(function() {
        agm_datatable_object
            .search(jQuery(this).val())
            .draw();
    });

    /***************************************************
     * Anzahl Elemente
     **************************************************/
    var agm_datatable_length = agm_datatable.parent().parent().find('#'+ agm_datatable_id + '_length');
    if(isBootstrap3) {
        agm_datatable_length.find('select').addClass('form-control');
    }

}



/* Default class modification */
jQuery.extend( jQuery.fn.dataTableExt.oStdClasses, {
    "sWrapper": "dataTables_wrapper form-inline"
} );


/* API method to get paging information */
jQuery.fn.dataTableExt.oApi.fnPagingInfo = function ( oSettings )
{
    return {
        "iStart":         oSettings._iDisplayStart,
        "iEnd":           oSettings.fnDisplayEnd(),
        "iLength":        oSettings._iDisplayLength,
        "iTotal":         oSettings.fnRecordsTotal(),
        "iFilteredTotal": oSettings.fnRecordsDisplay(),
        "iPage":          oSettings._iDisplayLength === -1 ? 0 : Math.ceil( oSettings._iDisplayStart / oSettings._iDisplayLength ),
        "iTotalPages":    oSettings._iDisplayLength === -1 ? 0 : Math.ceil( oSettings.fnRecordsDisplay() / oSettings._iDisplayLength )
    };
};


/* Bootstrap style pagination control */
jQuery.extend( jQuery.fn.dataTableExt.oPagination, {
    "bootstrap": {
        "fnInit": function( oSettings, nPaging, fnDraw ) {

            var oLang = oSettings.oLanguage.oPaginate;
            var fnClickHandler = function ( e ) {
                e.preventDefault();
                if ( oSettings.oApi._fnPageChange(oSettings, e.data.action) ) {
                    fnDraw( oSettings );
                }
            };

            console.log(fnDraw);

            jQuery(nPaging).append(
                '<div class="pagination">' +
                '<ul>'+
                '<li class="prev disabled"><a href="#">'+oLang.sPrevious+'</a></li>'+
                '<li class="next disabled"><a href="#">'+oLang.sNext+'</a></li>'+
                '</ul>' +
                '</div>'
            );
            var els = jQuery('a', nPaging);
            jQuery(els[0]).bind( 'click.DT', { action: "previous" }, fnClickHandler );
            jQuery(els[1]).bind( 'click.DT', { action: "next" }, fnClickHandler );
        },

        "fnUpdate": function ( oSettings, fnDraw ) {
            var iListLength = 5;
            var oPaging = oSettings.oInstance.fnPagingInfo();
            var an = oSettings.aanFeatures.p;
            var i, ien, j, sClass, iStart, iEnd, iHalf=Math.floor(iListLength/2);

            if ( oPaging.iTotalPages < iListLength) {
                iStart = 1;
                iEnd = oPaging.iTotalPages;
            }
            else if ( oPaging.iPage <= iHalf ) {
                iStart = 1;
                iEnd = iListLength;
            } else if ( oPaging.iPage >= (oPaging.iTotalPages-iHalf) ) {
                iStart = oPaging.iTotalPages - iListLength + 1;
                iEnd = oPaging.iTotalPages;
            } else {
                iStart = oPaging.iPage - iHalf + 1;
                iEnd = iStart + iListLength - 1;
            }

            for ( i=0, ien=an.length ; i<ien ; i++ ) {
                // Remove the middle elements
                jQuery('li:gt(0)', an[i]).filter(':not(:last)').remove();

                // Add the new list items and their event handlers
                for ( j=iStart ; j<=iEnd ; j++ ) {
                    sClass = (j==oPaging.iPage+1) ? 'class="active"' : '';
                    jQuery('<li '+sClass+'><a href="#">'+j+'</a></li>')
                        .insertBefore( jQuery('li:last', an[i])[0] )
                        .bind('click', function (e) {
                            e.preventDefault();
                            oSettings._iDisplayStart = (parseInt(jQuery('a', this).text(),10)-1) * oPaging.iLength;
                            fnDraw( oSettings );
                        } );
                }

                // Add / remove disabled classes from the static elements
                if ( oPaging.iPage === 0 ) {
                    jQuery('li:first', an[i]).addClass('disabled');
                } else {
                    jQuery('li:first', an[i]).removeClass('disabled');
                }

                if ( oPaging.iPage === oPaging.iTotalPages-1 || oPaging.iTotalPages === 0 ) {
                    jQuery('li:last', an[i]).addClass('disabled');
                } else {
                    jQuery('li:last', an[i]).removeClass('disabled');
                }
            }
        }
    },


    "bootstrap3": {
        "fnInit": function( oSettings, nPaging, fnDraw ) {

            var oLang = oSettings.oLanguage.oPaginate;
            var fnClickHandler = function ( e ) {
                e.preventDefault();
                if ( oSettings.oApi._fnPageChange(oSettings, e.data.action) ) {
                    fnDraw( oSettings );
                }
            };

            console.log(fnDraw);

            jQuery(nPaging).append(
                '<nav>' +
                '<ul class="pagination">'+
                '<li class="prev disabled"><a href="#">'+oLang.sPrevious+'</a></li>'+
                '<li class="next disabled"><a href="#">'+oLang.sNext+'</a></li>'+
                '</ul>' +
                '</nav>'
            );
            var els = jQuery('a', nPaging);
            jQuery(els[0]).bind( 'click.DT', { action: "previous" }, fnClickHandler );
            jQuery(els[1]).bind( 'click.DT', { action: "next" }, fnClickHandler );
        },

        "fnUpdate": function ( oSettings, fnDraw ) {
            var iListLength = 5;
            var oPaging = oSettings.oInstance.fnPagingInfo();
            var an = oSettings.aanFeatures.p;
            var i, ien, j, sClass, iStart, iEnd, iHalf=Math.floor(iListLength/2);

            if ( oPaging.iTotalPages < iListLength) {
                iStart = 1;
                iEnd = oPaging.iTotalPages;
            }
            else if ( oPaging.iPage <= iHalf ) {
                iStart = 1;
                iEnd = iListLength;
            } else if ( oPaging.iPage >= (oPaging.iTotalPages-iHalf) ) {
                iStart = oPaging.iTotalPages - iListLength + 1;
                iEnd = oPaging.iTotalPages;
            } else {
                iStart = oPaging.iPage - iHalf + 1;
                iEnd = iStart + iListLength - 1;
            }

            for ( i=0, ien=an.length ; i<ien ; i++ ) {
                // Remove the middle elements
                jQuery('li:gt(0)', an[i]).filter(':not(:last)').remove();

                // Add the new list items and their event handlers
                for ( j=iStart ; j<=iEnd ; j++ ) {
                    sClass = (j==oPaging.iPage+1) ? 'class="active"' : '';
                    jQuery('<li '+sClass+'><a href="#">'+j+'</a></li>')
                        .insertBefore( jQuery('li:last', an[i])[0] )
                        .bind('click', function (e) {
                            e.preventDefault();
                            oSettings._iDisplayStart = (parseInt(jQuery('a', this).text(),10)-1) * oPaging.iLength;
                            fnDraw( oSettings );
                        } );
                }

                // Add / remove disabled classes from the static elements
                if ( oPaging.iPage === 0 ) {
                    jQuery('li:first', an[i]).addClass('disabled');
                } else {
                    jQuery('li:first', an[i]).removeClass('disabled');
                }

                if ( oPaging.iPage === oPaging.iTotalPages-1 || oPaging.iTotalPages === 0 ) {
                    jQuery('li:last', an[i]).addClass('disabled');
                } else {
                    jQuery('li:last', an[i]).removeClass('disabled');
                }
            }
        }
    }
} );


/* Bootstrap style pagination control */
jQuery.extend( jQuery.fn.dataTableExt.oPagination, {
    "bootstrap_full": {
        "fnInit": function( oSettings, nPaging, fnDraw ) {
            var oLang = oSettings.oLanguage.oPaginate;
            var fnClickHandler = function ( e ) {
                e.preventDefault();
                if ( oSettings.oApi._fnPageChange(oSettings, e.data.action) ) {
                    fnDraw( oSettings );
                }
            };

            jQuery(nPaging).append(
                '<ul class="pagination">'+
                '<li class="first disabled"><a href="#">'+oLang.sFirst+'</a></li>'+
                '<li class="prev disabled"><a href="#">'+oLang.sPrevious+'</a></li>'+
                '<li class="next disabled"><a href="#">'+oLang.sNext+'</a></li>'+
                '<li class="last disabled"><a href="#">'+oLang.sLast+'</a></li>'+
                '</ul>'
            );
            var els = jQuery('a', nPaging);
            jQuery(els[0]).bind( 'click.DT', { action: "first" }, fnClickHandler );
            jQuery(els[1]).bind( 'click.DT', { action: "previous" }, fnClickHandler );
            jQuery(els[2]).bind( 'click.DT', { action: "next" }, fnClickHandler );
            jQuery(els[3]).bind( 'click.DT', { action: "last" }, fnClickHandler );
        },

        "fnUpdate": function ( oSettings, fnDraw ) {
            var iListLength = 5;
            var oPaging = oSettings.oInstance.fnPagingInfo();
            var an = oSettings.aanFeatures.p;
            var i, j, sClass, iStart, iEnd, iHalf=Math.floor(iListLength/2);

            if ( oPaging.iTotalPages < iListLength) {
                iStart = 1;
                iEnd = oPaging.iTotalPages;
            }
            else if ( oPaging.iPage <= iHalf ) {
                iStart = 1;
                iEnd = iListLength;
            } else if ( oPaging.iPage >= (oPaging.iTotalPages-iHalf) ) {
                iStart = oPaging.iTotalPages - iListLength + 1;
                iEnd = oPaging.iTotalPages;
            } else {
                iStart = oPaging.iPage - iHalf + 1;
                iEnd = iStart + iListLength - 1;
            }

            for ( i=0, iLen=an.length ; i<iLen ; i++ ) {
                // Remove the middle elements
                jQuery('li', an[i]).filter(":not(.first)").filter(":not(.last)").filter(":not(.prev)").filter(":not(.next)").remove();

                // Add the new list items and their event handlers
                for ( j=iStart ; j<=iEnd ; j++ ) {
                    sClass = (j==oPaging.iPage+1) ? 'class="active"' : '';
                    jQuery('<li '+sClass+'><a href="#">'+j+'</a></li>')
                        .insertBefore( jQuery('li.next', an[i])[0] )
                        .bind('click', function (e) {
                            e.preventDefault();
                            oSettings._iDisplayStart = (parseInt(jQuery('a', this).text(),10)-1) * oPaging.iLength;
                            fnDraw( oSettings );
                        } );
                }

                // Add / remove disabled classes from the static elements
                if ( oPaging.iPage === 0 ) {
                    jQuery('li.first', an[i]).addClass('disabled');
                    jQuery('li.prev', an[i]).addClass('disabled');
                } else {
                    jQuery('li.prev', an[i]).removeClass('disabled');
                    jQuery('li.first', an[i]).removeClass('disabled');
                }

                if ( oPaging.iPage === oPaging.iTotalPages-1 || oPaging.iTotalPages === 0 ) {
                    jQuery('li.last', an[i]).addClass('disabled');
                    jQuery('li.next', an[i]).addClass('disabled');
                } else {
                    jQuery('li.next', an[i]).removeClass('disabled');
                    jQuery('li.last', an[i]).removeClass('disabled');
                }
            }
        }
    }
} );