<?php
/**
 * @package    AGMedia Library
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Apr-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

/**
 * AgmLibBase library.
 * @since 1.0.0
 */
class AgmLibBase
{
	protected static $_version = '';
	
	/**
	* Get version of this AGMedia Library
	*
	* @return   int         $version        The Version of this AGMedia Library
	* @since    1.0.0
	*/
	public static function version() {
		
		if(empty(self::$_version)) {
			$db     = JFactory::getDbo();
			
			// Get component version
			$query  = $db->getQuery(true);
			$query ->select($db->qn(array('name', 'manifest_cache', 'type')))
			       ->from($db->qn('#__extensions'))
			       ->where($db->qn('type') . ' = ' . $db->q('library'))	
			       ->where($db->qn('element') . ' = ' . $db->q('agmlib'));	
			$db->setQuery($query);
			$result = $db->loadAssoc();
			
			$component_version = '';
			if(!empty($result['manifest_cache'])) {
			    $decode = json_decode($result['manifest_cache']);
				self::$_version = $decode->version;
			}		
		}	
		
		return self::$_version;
	}
   
	public static function versionCompare($version1, $operator, $version2) 
	{
		$_fv = explode('.', $version1);
		$_sv = explode('.', $version2);


		foreach($_fv as &$entry) {
			if(strlen($entry) < 2) {
				$entry = "0" . $entry;
			}
		}

		foreach($_sv as &$entry) {
			if(strlen($entry) < 2) {
				$entry = "0" . $entry;
			}
		}

		$_fv = implode($_fv);
		$_sv = implode($_sv);


	    
	    if (strlen ( $_fv ) > strlen ( $_sv )) {
	        $_sv = str_pad ( $_sv, strlen ( $_fv ), 0 );
	    }
	    
	    if (strlen ( $_fv ) < strlen ( $_sv )) {
	        $_fv = str_pad ( $_fv, strlen ( $_sv ), 0 );
	    }

	    $erg = version_compare((string) $_fv, (string) $_sv, $operator);
	   	    
	    return $erg;
	}
}//class
