 <?php
/**
 * @package    AgmLib
 * @subpackage Calendar
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Jun-2019
 * @license    GNU/GPL
 */

//-- No direct access
defined('_JEXEC') || die(';=)');

// namespace MathCaptcha;


/**
 * AgmLibCaptcha
 *
 */
class AgmLibCalendar
{
    /**
     * Funktion rendert einen kleinen Minikalender der einen Monat als Übersicht anzeigt.
     *
     * @param (int)   $year     Das Jahr das angezeigt werden soll
     * @param (int)   $month    Der Monat der angezeigt werden soll
     * @param (array) $options  Optionen Array. Erklärung: $tag (1-31)
     *                          [$tag]['href'] = Link für onklick
     *                          [$tag]['background'] = #color
     *                          [$tag]['font_color'] = #color
     */
    public static function renderMiniCalendar($year, $month, $options = array()) {
        setlocale(LC_ALL, 'de_DE.utf8');
      
        // Check month
        $month = self::checkMonth($month);

        // Check year
        $year = self::checkYear($year);
        
//         $doc = JFactory::getDocument();
//         $doc->addStylesheet(JURI::base(true) .'/libraries/agmlib/calendar/calendar.css');
//         echo JURI::base(true) .'/agmlib/calendar/calendar.css';
//         exit;

        $dt = new DateTime();
        $dt->setDate($year, $month, 1);   // Year, Month, Day
        $dt->setTime(0,0,0,1);            // Hour, Minute, Second, Microsecond

        $calendar = array();
        $week = array();
        $day = 0;
        $daysInMonth = self::getNumOfDaysInMonth($year, $month);
        
        // Create weeks in a month
        for( $i=0; $i < self::getNumOfWeeksInMonth($year, $month); $i++ ){

            $week = array();
            //Loop days in a week
            for($j=1; $j<=7; $j++){
                
                
                if($day == 0) {
                    $firstDayOfTheWeek = date('N', strtotime($year.'-'.$month.'-01'));

                    if(intval($i*7+$j) == intval($firstDayOfTheWeek)){
                        $day = 1;
                    }
                }

                if( ($day != 0) && ($day <= $daysInMonth) ){

//                     $this->currentDate = date('Y-m-d',strtotime($this->currentYear.'-'.$this->currentMonth.'-'.($day)));

                    $cellContent = $day;
                    $day++;   

                } else {

//                     $this->currentDate =null;
                    $cellContent = null;
                }                
                
                $week[] = $cellContent;
                
            }
            
            $calendar[] = $week;
        }        
    
        $col_names = array();
        $col_names[] = 'Mo';
        $col_names[] = 'Di';
        $col_names[] = 'Mi';
        $col_names[] = 'Do';
        $col_names[] = 'Fr';
        $col_names[] = 'Sa';
        $col_names[] = 'So';
        
        //---------------------------------------------------------------------------------------------
        // BUILD THE TABLE
        //---------------------------------------------------------------------------------------------
        $table  = '<table class="agm_minical">';
        $table .= '  <thead>';
        $table .= '    <tr class="agm_minical_th_month">';
        $table .= '      <th colspan="7">'.strftime("%B", $dt->getTimestamp()).' - '.$year.'</th>';
        $table .= '    </tr>';
        $table .= '  </thead>';
        $table .= '  <tbody>';
        
        // Wochentage Header
        $table .= '    <tr class="agm_minical_td_weekdays">';
        foreach($col_names as $col_name) {
            $table .= '<td>'.$col_name.'</td>';
        }
        $table .= '    </tr>';
    
        //Logik hier raus
        $bookings = self::getBookings();
//         echo "<pre>"; print_r($bookings); exit;
        $dt_temp = new DateTime();
        
        // Reihen mit den Tagen        
        foreach($calendar as $week) {
            $table .= '<tr class="agm_minical_td_days">';
            
            foreach($week as $day) {
                $background = '';
                $has_bookings = false;
                
                if($day > 0) {
                    $day_2digits = str_pad($day, 2 ,'0', STR_PAD_LEFT);
                    $month_2digits = str_pad($month, 2 ,'0', STR_PAD_LEFT);
                  
                    //Onetime Bookings
                    if(!empty($bookings['onetime'][$year][$month_2digits][$day_2digits])) 
                    {
                        $has_bookings = true;
                        $background = '#80c3ff';
                    }
                    
                    //Recurring bookings (nur durchgehen, wenn nicht eh schon gehighlighed ist)
                    $dt_temp->setDate($year, $month, $day);
                    if(    !$has_bookings
                        && (array_key_exists($dt_temp->format('N'), $bookings['recurring']))
                      ) 
                    {
                        foreach($bookings['recurring'] as $booking) 
                        {
                            $dt_booking_start = new DateTime($booking['recurring_start']);
                            $dt_booking_end   = new DateTime($booking['recurring_end']);
                            if(($dt_booking_start <= $dt_temp) && ($dt_temp <= $dt_booking_end)) {
                                $has_bookings = true;
                                $background = '#80c3ff';
                                break;
                            }
                        }
                    }
                }
                    
                
                $class = (empty($day)) ? 'empty' : '';
                
                $href = (!empty($options[$day]['href'])) ? $options[$day]['href'] : '';
                $background = (!empty($options[$day]['background'])) ? $options[$day]['background'] : $background;
                $font_color = (!empty($options[$day]['font_color'])) ? $options[$day]['font_color'] : '';
                
                $style = '';
                $style_a = '';
                if(!empty($background)) $style .= 'background: '. $background .'; ';
                if(!empty($font_color)) $style .= 'color: '. $font_color .'; '; $style_a .= 'color: '. $font_color .'; ';
                    
                $table .= '<td class="'.$class.'" style="'.$style.'">';    
                
                if(!empty($href)) {
                    $table .= '<a style="'.$style_a.'" href="'.$href.'">'.$day.'</a>';    
                } else {
                    $table .= '<a>'.$day.'</a>'; 
                }
                
                $table .= '</td>';    
            }
            
            $table .= '</tr>';
        }
        
        $table .= '  </tbody>';
        $table .= '</table>';
        return $table;
        

    }
    
    public static function renderDayView($date) {
        setlocale(LC_ALL, 'de_DE.utf8');
        
        list($y, $m, $d) = explode('-', $date);
        $m = str_pad($m, 2 ,'0', STR_PAD_LEFT);
        $d = str_pad($d, 2 ,'0', STR_PAD_LEFT);        
        //TODO CHECK INPUT
        
        $start_time = '08:00';
        $end_time = '23:00';
        
        $dt = new DateTime($date);
        
        $tStart = strtotime($start_time);
        $tEnd = strtotime($end_time);
        $tNow = $tStart;

        $blocks = array();
        $bookings = self::getBookings();
//         echo "<pre>";
//         print_r($bookings); exit;
        
        while($tNow < $tEnd){
            $block = array();
            $block['start_time'] = date("H:i",$tNow);
            
            //Defaults
            $block['bookable']   = true;
            $block['rowspan'] = 0;
            
            //Recurring records durchgehen
            if(!empty($bookings['recurring'])) {
                if(array_key_exists($dt->format('N'), $bookings['recurring'])) { 
                    foreach($bookings['recurring'] as $recurring_booking) {
                        
                        //Prüfen ob der anzuzeigende Tag zwischen der Gültigkeitsdauer der Wiederholung liegt
                        $dt_booking_start = new DateTime($recurring_booking['recurring_start']);
                        $dt_booking_end   = new DateTime($recurring_booking['recurring_end']);
                        
                        if(($dt < $dt_booking_start) || ($dt_booking_end < $dt)) {
                            continue;
                        }
                        
                        $recurring_booking['booking_start'] = substr($recurring_booking['booking_start'], 0, -3);   //xx:xx:xx ==> xx:xx
                        $recurring_booking['booking_end']   = substr($recurring_booking['booking_end'], 0, -3);   //xx:xx:xx ==> xx:xx
                        
                        if(     ($block['start_time'] >= $recurring_booking['booking_start']) 
                            &&  ($block['start_time'] < $recurring_booking['booking_end']) 
                          ) {
                            $block['bookable']   = false;    
                            
                            if($block['start_time'] == $recurring_booking['booking_start']) {
                                $t_start = strtotime($recurring_booking['booking_start']);
                                $t_end = strtotime($recurring_booking['booking_end']);
                                $t = (($t_end - $t_start) / 3600) * 2;    //*2 um von Std. Blöcke auf Halbstd. Blöcke zu kommen
                                $block['rowspan'] = $t;
                            }
                            
                            $block['user'] = $recurring_booking['user'];
                            $block['desc'] = $recurring_booking['desc'];
                        }
                    }
                }
            }
            
            //Onetime Bookings
            if(!empty($bookings['onetime'][$y][$m][$d])) {
                foreach($bookings['onetime'][$y][$m][$d] as $onetime_booking) {
                    $onetime_booking['booking_start'] = substr($onetime_booking['booking_start'], 0, -3);   //xx:xx:xx ==> xx:xx
                    $onetime_booking['booking_end']   = substr($onetime_booking['booking_end'], 0, -3);   //xx:xx:xx ==> xx:xx

                    if(     ($block['start_time'] >= $onetime_booking['booking_start']) 
                        &&  ($block['start_time'] < $onetime_booking['booking_end']) 
                      ) {
                        $block['bookable']   = false;    

                        if($block['start_time'] == $onetime_booking['booking_start']) {
                            $t_start = strtotime($onetime_booking['booking_start']);
                            $t_end = strtotime($onetime_booking['booking_end']);
                            $t = (($t_end - $t_start) / 3600) * 2;    //*2 um von Std. Blöcke auf Halbstd. Blöcke zu kommen
                            $block['rowspan'] = $t;
                        }
                        
                        $block['user'] = $onetime_booking['user'];
                        $block['desc'] = $onetime_booking['desc'];
                    }
                }
            }
            
            $tNow = strtotime('+30 minutes',$tNow);
            
            $blocks[] = $block;
        }   
        
//         echo "<pre>";
//         print_r($blocks);
//         exit;
        
        $dt = new DateTime($date);
        
        //---------------------------------------------------------------------------------------------
        // BUILD THE TABLE
        //---------------------------------------------------------------------------------------------
        $table  = '<table id="agm_minical_dayview" class="agm_minical">';
        $table .= '  <thead>';
        $table .= '    <tr class="agm_minical_th_month">';
        $table .= '      <th colspan="3">'.strftime("%A", $dt->getTimestamp()).' - '.$dt->format('d.m.Y').'</th>';
        $table .= '    </tr>';
        $table .= '  </thead>';
        $table .= '  <tbody>';
        
        foreach($blocks as $block) {
            $table .= '<tr class="agm_minical_td_block">';
            $table .= '  <td>'.$block['start_time'].'</td>';
            
            $cb = ($block['bookable'] == true) ? '<input name="time[]" type="checkbox" value="'.$block['start_time'].'">' : '';
            
            
            if(     ($block['bookable'] == false)
                &&  ($block['rowspan'] > 0)
              ) {
//             echo "<pre>";
//             print_r($block); exit;
                $table .= '  <td rowspan="'.$block['rowspan'].'"></td>';   
                $table .= '  <td rowspan="'.$block['rowspan'].'">';
                $table .= '     <div>'.$block['user']->name.'</div>';
                $table .= '     <div>'.$block['desc'].'</div>';
                $table .= '  </td>';   
            } else if($block['bookable'] == true) {
                $table .= '  <td>'.$cb.'</td>';
                $table .= '  <td>frei</td>';
            }
            
            $table .= '</tr>';    
        }
        
        $table .= '  </tbody>';
        $table .= '</table>';       
        return $table;
    }

    
    public static function getNumOfDaysInMonth($year, $month) {
        // Check month
        $month = self::checkMonth($month);

        // Check year
        $year = self::checkYear($year);

        $daysInMonth = date('t',strtotime($year.'-'.$month.'-01'));
        
        return $daysInMonth;
    }
    
    public static function getNumOfWeeksInMonth($year, $month) {
        // Check month
        $month = self::checkMonth($month);

        // Check year
        $year = self::checkYear($year);

        $daysInMonth = self::getNumOfDaysInMonth($year, $month);
        
        $numOfweeks = ($daysInMonth % 7 == 0 ? 0 : 1) + intval($daysInMonth / 7);

        $monthEndingDay= date('N',strtotime($year.'-'.$month.'-'.$daysInMonth));
        $monthStartDay = date('N',strtotime($year.'-'.$month.'-01'));

        if($monthEndingDay < $monthStartDay){
            $numOfweeks++;
        }

        return $numOfweeks;      
    }  
    
    //*******************************************************************************************************************************
    // PRIVATE 
    //*******************************************************************************************************************************
    private function getBookings() {
        $db = JFactory::getDbo();
        
        //----------------------------------------------------------------------------------------------------
        // Recurring records
        //----------------------------------------------------------------------------------------------------
        $query = $db->getQuery(true);
        $query  ->select('*')
                ->from('#__clubmanager_bookings');
                
        $conditions = array();
        $conditions[] = $db->quoteName('recurring') .' = '. $db->q(1);
        
        if(!empty($conditions)) 
        {            
            $query->where($conditions);
        }
        
        $db->setQuery($query);
        $db->execute();
        $num_rows   = $db->getNumRows();
        $result     = $db->loadAssocList();         
        
        $bit_mask = array();
        $bit_mask[1] = 1;
        $bit_mask[2] = 2;
        $bit_mask[3] = 4;
        $bit_mask[4] = 8;
        $bit_mask[5] = 16;
        $bit_mask[6] = 32;
        $bit_mask[7] = 64;
        
        $recurring_bookings = array();
        if($num_rows > 0) {
            foreach($result as &$recurring_booking) {
                //User nachladen
                $user = JFactory::getUser($recurring_booking['user_id']);
                if(!empty($user->id)) {
                    $recurring_booking['user'] = $user;
                }
              
                for($i=1; $i<=7; $i++) {
                    if(($recurring_booking['recurring_cycle'] & $bit_mask[$i]) == $bit_mask[$i]) {
                        $recurring_bookings[$i] = $recurring_booking;    
                    }
                }
            }
        } //end of num_rows > 0
        
        //----------------------------------------------------------------------------------------------------
        // Onetime records
        //----------------------------------------------------------------------------------------------------
        $query = $db->getQuery(true);
        $query  ->select('*')
                ->from('#__clubmanager_bookings');
                
        $conditions = array();
        $conditions[] = $db->quoteName('recurring') .' = '. $db->q(0);
        
        if(!empty($conditions)) 
        {            
            $query->where($conditions);
        }
        
        $db->setQuery($query);
        $db->execute();
        $num_rows   = $db->getNumRows();
        $result     = $db->loadAssocList();         
        
        $onetime_bookings = array();
        if($num_rows > 0) {
            foreach($result as &$onetime_booking) {
                //User nachladen
                $user = JFactory::getUser($onetime_booking['user_id']);
                if(!empty($user->id)) {
                    $onetime_booking['user'] = $user;
                }                     
                
                list($y, $m, $d) = explode('-', $onetime_booking['booking_date']);
                $onetime_bookings[$y][$m][$d][] = $onetime_booking;
            }
        } //end of num_rows > 0        
        
        
        
        $bookings = array();
        $bookings['recurring'] = $recurring_bookings;
        $bookings['onetime']   = $onetime_bookings;
        
//         echo "<pre>";
//         print_r($bookings);
//         exit;

        return $bookings;
    }
    
    private function checkMonth($month) {
        // Check month
        $month = (int) $month;
        if(($month < 1) || ($month > 12)) {
          throw new Exception('Invalid month');
        }     
        
        return $month;
    }
    
    private function checkYear($year) {
        // Check month
        $year = (int) $year;
        
        return $year;
    }    
}//class