<?php
/**
 * @package    AgmLib
 * @subpackage Captcha
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Jan-2019
 * @license    GNU/GPL
 */

//-- No direct access
defined('_JEXEC') || die(';=)');

// namespace MathCaptcha;


/**
 * AgmLibCaptcha
 *
 */
class AgmLibCaptcha
{
// 	private $addNum1;
// 	private $addNum2;
// 	private $answer     = null;
// 	private $captchaImg = null;
// 	private $captchaID  = 0;
    
  /**
	 * Funktion generiert ein Captcha in Form einer Zahlenberechnung
	 * Es werden nur Ergebnisse zugelassen die größer als 0 sind
	 * 
	 * Speichert den String sowie das Ergebnis in einer Session Variable ab
	 *	$session->set('agm_captcha_string', $string);
	 *	$session->set('agm_captcha_result', $ergebnis);
	 *	
	 *	return $string;
	 */
	public static function get() {
		$session = JFactory::getSession();
		
		$zahlen_in_worten = array();
		$zahlen_in_worten[1] = 'eins';
		$zahlen_in_worten[2] = 'zwei';
		$zahlen_in_worten[3] = 'drei';
		$zahlen_in_worten[4] = 'vier';
		$zahlen_in_worten[5] = 'fünf';
		$zahlen_in_worten[6] = 'sechs';
		$zahlen_in_worten[7] = 'sieben';
		$zahlen_in_worten[8] = 'acht';
		$zahlen_in_worten[9] = 'neun';
		
		$operator = array();
		$operator[1] = 'plus';
		$operator[2] = 'minus';
		
		
		do {
			$calcable = false;
			$rand_1 = rand(1,9);
			$rand_2 = rand(1,9);
			$rand_operator = rand(1,2);
			
			// erwartetes Ergebnis
			switch ($rand_operator) {
				case 1: // PLUS
					$ergebnis = $rand_1 + $rand_2;
					break;
					
				case 2: // MINUS
					$ergebnis = $rand_1 - $rand_2;
					break;
				
				default:
					throw new Exception ("Fehler im Operator");
					break;
			}	
			
			// Nur ergebnisse zulassen die größer als 0 sind
			if($ergebnis > 0) $calcable = true;
		} while($calcable == false);
	
        $captcha_id = AgmLibSerials::generateActivationCode(1, 12);
        
        $session_name_string = 'agm_captcha_string_'.$captcha_id;
        $session_name_result = 'agm_captcha_result_'.$captcha_id;
		
		$string = 'SPAMCHECK: Berechne das Ergebnis von: '. $zahlen_in_worten[$rand_1] .' '. $operator[$rand_operator] .' '. $rand_2;
		
		$session->set($session_name_string, $string);
		$session->set($session_name_result, $ergebnis);
		
        $return = array();
        $return['string'] = $string;
        $return['captcha_id'] = $captcha_id;
		
        return $return;
	}
	
	/**
	 * Funktion vergleich einen übergebene Wert mit dem Resultat das in der Session Variable gespeichert ist
	 * 
	 * @param	$input_value	"Ergebnis Wert"
	 * @return	true/false
	 */
	public static function check($input_value, $captcha_id) {
		$session = JFactory::getSession();
		
        if(empty($captcha_id)) return 'Invalid captcha_id';
        
        $session_name_string = 'agm_captcha_string_'.$captcha_id;
        $session_name_result = 'agm_captcha_result_'.$captcha_id;
        
		$input_value = (int) $input_value;
        
        if(empty($session->get($session_name_result))) return 'Session empty';
		
		if($input_value == $session->get($session_name_result)) {
			return true;
		} else {
			return false;
		}
	}	    
    
	
// 	public function __construct( $captchaID = 0 ) {
		
// 		$this->captchaID = 'math_captcha_' . $captchaID;
		
// 		// Set the captcha result from last generated captcha and unset it from the session
// 		if ( isset($_SESSION[$this->captchaID]) ) {
// 			$this->answer = $_SESSION[$this->captchaID];
// 			unset($_SESSION[$this->captchaID]);
// 		}
		
// 	}
	
// 	public function generate () {
		
// 		$this->addNum1 = rand(0, 10) * rand(1, 3);
// 		$this->addNum2 = rand(0, 10) * rand(1, 3);
		
// 		// Set the captcha result for current captcha and set it to the session for later check
// 		$_SESSION[$this->captchaID] = $this->answer = $this->addNum1 + $this->addNum2;
// 		// Create a canvas
// 		if ( ($this->captchaImg = @imagecreatetruecolor(99, 19)) === false ) {
// 			throw new MathCaptchaException('Creation of true color image failed');
// 		}
		
// 		// Allocate black and white colors
// 		$color_black = imagecolorallocate($this->captchaImg, 0, 0, 0);
// 		$color_white = imagecolorallocate($this->captchaImg, 255, 255, 255);
		
// 		// Make the background of the image white
// 		imagefilledrectangle($this->captchaImg, 0, 0, 99, 19, $color_white);
		
// 		// Draw the math question on the image using black color
// 		imagestring($this->captchaImg, 10, 2, 2,  $this->addNum1 . ' + ' . $this->addNum2 . ' = ', $color_black);
		
// 	}
	
// 	public function output () {
		
// 		if ( $this->captchaImg === null ) {
// 			throw new MathCaptchaException('Captcha image has not been generated');
// 		}
		
// 		header('Content-Disposition: Attachment;filename=captcha.png');
// 		header('Content-Type: image/png');
		
// 		imagepng($this->captchaImg);
// 		imagedestroy($this->captchaImg);
// 	}
	
// 	public function check ( $answer ) {
		
// 		// Check if math captcha has been generated
// 		if ( $this->answer === null ) {
// 			return false;
// 		}
// 		// Validate captcha
// 		if ( $this->answer === (int) trim($answer) ) {
// 			return true;
// 		}
// 		else {
// 			return false;
// 		}
		
// 	}
	

}//class