<?php
/**
 * @package    AGMedia Library
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Apr-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

/**
 * AgmLib library.
 * @since 1.0.0
 */
class AgmLibExtension
{
    private static $_debug = false;
        

   /**
     * PHP Function um zu prüfen ob eine Komponente installiert ist
     *
     */
   public static function isInstalled($component = '')
   { 
      $db = JFactory::getDBO();
      
      if(empty($component)) return false;
      
      //Array mit einer Liste von allen Datenbanktabellen
      $query = $db->getQuery(true);
      $query
         ->select('*')
         ->from('#__extensions');
	  $search = $db->quote('%' . str_replace(' ', '%', $db->escape(trim($component), true) . '%'));
	  $query->where('(element LIKE ' . $search . ')');         
                
      $db->setQuery($query);
      $result = $db->loadAssoc();
      
      if(!empty($result['extension_id'])) {
         return true;
      } else {
         return false;
      }
   }
}