<?php
/**
 * @package    AGMedia Library
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Feb-2019
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

//Import der Helfer
require_once(JPATH_LIBRARIES . '/agmlib/assets/vendor/php-iban-master/oophp-iban.php');

class AgmLibIbanvalidator
{
    /**
     * Methode prüft ob IBAN gültig ist
     *
     * @param   string      $iban   The IBAN to validate
     * @return  boolean
     *
     * @since   agmlib v1.0.8
     */
    public static function validateIban($iban)
    {
        //Check if param is not empty
        if(empty($iban))
            return false;

        $iban = trim($iban);                          //Unzulässige Zeichen am Anfang & Ende entfernen
        $iban = preg_replace('/\s+/', '', $iban);     //Leerzeichen entfernen        
        
        //Get instance of iban validator
        $iban_validation = new IBAN($iban);

        //Check iban
		if(!$iban_validation->Verify())
			return false;
        
        return $iban;
    }
    
    /**
     * Methode liefert passende BIC und Bankname zu einer IBAN
     *
     * @param   string      $iban
     * @return  array       ['iban'] => the IBAN
                            ['bic]   => the BIC
                            ['name]  => name of the bank
     * @since   agmlib v1.0.8
     */
	public static function getBicBank($iban) {
        //Check if param is not empty
        if(empty($iban))
            return false;

        $iban = self::validateIban($iban);
        if($iban == false)
            return array();
        
        $return = array();

		/*echo "### generateBICAndNameOfBank ###\n";*/

		//Load XML File
		$file = JPATH_LIBRARIES . '/agmlib/assets/vendor/php-iban-master/xml_blz_bic/bank_blz_bic.xml';
		$blz_bic = simplexml_load_file($file);

// 		echo "FILE:\n";
// 		echo $file ."\n";
// 		var_dump(JFile::exists($file));
// 		echo "\n\n";

// 		echo "<pre>";
// 		var_dump($blz_bic);
// 		echo "</pre>";
//         exit;
       

		//Get a Search Result
		$result = false;

		/*echo "BLZ: ". $iban->Bank() ."\n";*/

		if($blz_bic) {
			/*echo "Start search\n";*/
            $iban_validation = new IBAN($iban);
			$res = $blz_bic->xpath("bank/blz[. = '".$iban_validation->Bank()."']/parent::*");
			/*print_r($res);
			echo "\n";*/
			if(count($res) > 0) {
				foreach($res as $key => $record) {
					if(!empty($record->bic)) {
						$target_key = $key;
						/*echo "Target Key Found: ". $target_key ."\n";*/
					}
				}
			}

			$return = json_decode(json_encode($res[$target_key]), true);
			$return['iban'] = $iban_validation->iban;
			/*echo "Result:\n";
			print_r($result);*/
		}

		return $return;
	}    
}