<?php
/**
 * @package    AGMedia Library
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Apr-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');


/**
 * AgmLib library.
 * @since 1.0.0
 */
class AgmLibScripts
{
	public static function loadAgmBs4()
	{
		$document = JFactory::getDocument();
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/agm-bs4/bootstrap-agm.css');
		$document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/agm-bs4/button.js');
	}	
	
	public static function loadTingle()
	{
		$document = JFactory::getDocument();
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/vendor/tingle/tingle.min.css');
		$document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/vendor/tingle/tingle.min.js');
	}
	
    public static function loadDatatable()
	{
		$document = JFactory::getDocument();
// 		$document->addStyleSheet('//cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css');
		$document->addScript('//cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js');
	}

	/**
	 * PHP Function um Summernote zu laden
	 */
	public static function loadSummernote()
	{
		$document = JFactory::getDocument();
		$document->addStyleSheet('https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.1/summernote.css');
		$document->addScript('https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.1/summernote.js');
	}

	public static function loadSelect2() {
		$document = JFactory::getDocument();
		$document->addStyleSheet('https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css');
		$document->addScript('https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/js/select2.min.js');
	}

	public static function loadBlockUI($override_default_options = true) {
		$document = JFactory::getDocument();
		$document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/js/blockUI/jQuery.blockUI.js');

		//Set the default options
		if($override_default_options) {
			$document->addScriptDeclaration("
			jQuery.blockUI.defaults.message = '<i class=\"icon-spinner4 spinner\"></i>';
			jQuery.blockUI.defaults.overlayCSS = {
						backgroundColor: '#91C3DC',
					    opacity: 0.8,
					    cursor: 'wait'
		    };
			jQuery.blockUI.defaults.css = {
					    border: 0,
					    padding: 0,
					    backgroundColor: 'transparent'
		    };
		");
		}
	}

	public static function loadFilestyle() {
		$document = JFactory::getDocument();
		$document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/js/filestyle/bootstrap-filestyle.min.js');
	}

	public static function loadLadda() {
		$document = JFactory::getDocument();
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/js/ladda/ladda-themeless.min.css');
		//$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/js/ladda/ladda.min.css');
		$document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/js/ladda/spin.min.js'); //Needs to be loaded before ladda.min.js if use javascript version
		$document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/js/ladda/ladda.min.js');
		$document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/js/ladda/ladda.jquery.js'); //Needs to be loaded after ladda.min.js
	}

	public static function loadFiler() {
		$document = JFactory::getDocument();
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/js/filer/css/jquery.filer.css');
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/js/filer/css/themes/jquery.filer-dragdropbox-theme.css');
		$document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/js/filer/js/jquery.filer.min.js');
	}
	
	/**
	 * @since 1.0.4
	 */
	public static function loadClipboard() {
		$document = JFactory::getDocument();
		$document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/js/clipboard/clipboard.min.js');	
	}	
	
	/**
	 * @since 1.0.4
	 */
	public static function loadNoty() {
		$document = JFactory::getDocument();
		$document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/js/noty/noty.min.js');	
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/js/noty/noty.css');
		
		$document->addScriptDeclaration("
			Noty.overrideDefaults({
				timeout	 : '5000',
			});
		");
	}		
	
	/**
	 * @since 1.0.4
	 */
	public static function loadFontawesome() {
		$document = JFactory::getDocument();
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/fontawesome/css/all.css');
	}		
    
    public static function loadBootstrap_4_iso() {
        $document = JFactory::getDocument();
		$document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/bootstrap_4-0-0_iso.css');
    }
    
	/**
	 * @since 1.0.8
	 */    
    public static function loadPdfObject()
    {
		$document = JFactory::getDocument();
		$document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/vendor/pdfobject/pdfobject.2.1.1.min.js');	        
    }
  
  /**
	 * @since 1.0.?
	 */    
    public static function loadLoadingBtn()
    {
		    $document = JFactory::getDocument();
        $document->addScript(JUri::root( true ) . '/libraries/agmlib/assets/js/loadingbtn/loadingbtn.js');	 
    }
  
    public static function loadLoader()
    {
		    $document = JFactory::getDocument();
        $document->addStyleSheet(JUri::root( true ) . '/libraries/agmlib/assets/css/loading.io.css'); 
    }  
}