<?php
/**
 * @package    agmserials
 * @subpackage helpers
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');


/**
 * Sponsorswall Helper.
 *
 * @package     Sponsorswall
 * @subpackage  Helpers
 * @since       1.0.0
 */
class AgmLibSerials
{
    /**
     * @var array Available characters.
     */
    protected static $availableCharacters = [];
    /**
     * @var integer Number of total chunks. Default is 5. Example: XXXXX-BBBBB-ZZZZZ-AAAAA-YYYYY
     */
    protected static $numberChunks = 1;
    /**
     * @var integer Number of total letters per chunk. Default is 5. Example: XXXXX-XXXXX-XXXXX-XXXXX
     */
    protected static $numberLettersPerChunk = 12;
    /**
     * @var string Separate chunk by text. Default is '-' (without single quote).
     */
    protected static $separateChunkText = '-';
    /**
     * @var integer Total available characters. This is for calculation only.
     */
    protected static $totalAvailableCharacters = 0;

	public static function generateActivationCode($num_chunks, $num_letters_per_chunk)
	{
        self::$availableCharacters      = self::availableCharacters();
        self::$totalAvailableCharacters = count(self::$availableCharacters);        
        
		self::$numberChunks             = (int) $num_chunks;
		self::$numberLettersPerChunk    = (int) $num_letters_per_chunk;
		
		$activation_key = false;
			
		for($i=0;$i<=20;$i++) {
			$tmp_activation_key = self::generate();
			
// 			if(self::checkActivationCodeUnique($tmp_activation_key)) {
// 				$activation_key = $tmp_activation_key;
// 			} else {
// 				continue;
// 			}
            
            $activation_key = $tmp_activation_key;
            break;
		}
		return $activation_key;
	}
    
    
    
    
    
    
    
    
    
    
    /**
     * Get all available characters.
     * 
     * @return array Return array of available characters.
     */
    protected function availableCharacters()
    {
        // number come first. any letters that ambiguous with number will be comment out.
        return [
            '0', // ambiguous with O
            '1', // ambiguous with I J L T
            '2', // ambiguous with Z	
            '3',
            '4',
            '5', // ambiguous with S
            '6',
            '7',
            '8', // ambiguous with B
            '9',
            'A',
            //'B',	// ambiguous with 8
            'C',
            'D',
            'E',
            'F',
            'G',
            'H',
            //'I',	// ambiguous with I J L T
            //'J',	// ambiguous with I J L T
            'K',
            //'L',	// ambiguous with I J L T
            'M',
            'N',
            //'O',	// ambiguous with O
            'P',
            'Q',
            'R',
            //'S',	// ambiguous with S
            //'T',		// ambiguous with I J L T
            'U', // ambiguous with V
            //'V', // ambiguous with U, double V (VV) or double u (W). so, i prefer W because V also ambiguous with U but U not ambiguous with W.
            'W',
            'X',
            'Y',
            //'Z',	// ambiguous with 2
        ];
    }// availableCharacters
    
    /**
     * Generate the serial number.
     * 
     * @return string Return generated serial number.
     */
    private function generate()
    {
        self::validateProperties();
        $output = '';
        for ($chunk = 1; $chunk <= self::$numberChunks; $chunk++) {
            for ($letter = 1; $letter <= self::$numberLettersPerChunk; $letter++) {
                if (function_exists('mt_rand')) {
                    $output .= self::$availableCharacters[mt_rand(0, (self::$totalAvailableCharacters - 1))];
                } else {
                    $output .= self::$availableCharacters[array_rand(self::$availableCharacters)];
                }
            }// endfor;
            unset($letter);
            if ($chunk < self::$numberChunks) {
                $output .= self::$separateChunkText;
            }
        }// endfor;
        unset($chunk);
        return $output;
    }// generate
    
    /**
     * Reset all properties and begins again.
     */
    private function reset()
    {
        self::$availableCharacters = self::availableCharacters();
        self::$numberChunks = 5;
        self::$numberLettersPerChunk = 5;
        self::$separateChunkText = '-';
        self::$totalAvailableCharacters = count(self::$availableCharacters);
    }// reset
    
    /**
     * Validate properties that it contain valid format and value.<br>
     * If something invalid, it will automatically call to reset() method.
     */
    protected function validateProperties()
    {
        if (!is_array(self::$availableCharacters) || empty(self::$availableCharacters)) {
            self::reset();
        }
        if (!is_int(self::$numberChunks) || !is_int(self::$numberLettersPerChunk) || self::$numberChunks < 1 || self::$numberLettersPerChunk < 1) {
            self::reset();
        }
        if (!is_numeric(self::$totalAvailableCharacters)) {
            self::reset();
        }
    }// validateProperties    
}