<?php
/**
 * @package    AGMedia Library
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Apr-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

use Joomla\Registry\Registry;

class AgmLibValidation
{
    protected static $session_namespace = 'AgmLibValidation';
	
    public static function getValidationStatus($component = '', $force_check = false)
    {
        $debug   = false;
        $session = JFactory::getSession();
        
        $session_has 	= $session->has('validation_status', self::$session_namespace);
        $session_valid 	= false;
        $session_serial = $session->get('validated_serial', '0', self::$session_namespace);
        
        $param_serial = JComponentHelper::getParams($component)->get('agm_serial');
        $serial       = (!empty($param_serial)) ? $param_serial : '';			
		
		
		// Prüfen ob validiert werden muss weil irgendwelche Parameter geändert wurden
        if ($force_check || ($session_serial != $serial) || $debug) {
            $session->set('validation_status', '0', self::$session_namespace);
			$session->set('validated_serial', '0', self::$session_namespace);
        }		
		
        // Prüfen ob die Validierung bereits durchgeführt wurde
		if($session_has)
		{
            $session_value = $session->get('validation_status', '0', self::$session_namespace);
			if($session_value === '1337') {
				$session_valid = true;
			}			
		}

        if($debug) {
        	echo "<br>";
        	echo "-------------><br>";
        	echo "component: ". $component ."<br>";
        	echo "serial: ". $serial ."<br>";
        	echo "session_serial: ". $session_serial ."<br>";
        	
        	echo "session->has(): ";
        	var_dump($session_has);
        	echo "<br>";
        	
        	echo "session value: ". $session_value ."<br>";
        	echo "session_valid: ";
        	var_dump($session_valid);
        	echo "<br>";
        }
        
        if($session_valid)
        {
            return true;
        }
        
		return self::checkValidationStatus($serial);   
    }
	
    public static function checkValidationStatus($serial)
    {
    	$debug  	  = false;
        $host         = JUri::getInstance()->getHost();
        $return_value = 0;
        $session      = JFactory::getSession();
         
		if(empty($serial)) 
		{
			return -99;
        }
            
        if (JHttpFactory::getAvailableDriver(new Registry) == false) {
            $return_value = -1;
        }
        if (!empty($host) AND !empty($serial) AND $return_value == 0) {
			//TODO check https
            $url_check = 'https://agmedia.de/index.php?option=com_agmserials&view=validate&key=' . rawurlencode($serial) . '&host=' . rawurlencode($host) . '&request_key=' . self::generateHash();
            try {
                $serial_request = JHttpFactory::getHttp()->get($url_check);
            }
            catch (Exception $e) {
                $return_value = -2;
            }
            if (!empty($serial_request->body) AND $return_value == 0) {
                if (preg_match('@(error|access denied)@i', $serial_request->body)) {
                    $return_value = -3;
                }
                if ($return_value == 0) {
                    $serial_check = json_decode($serial_request->body);
                    if ($serial_check->success != 1 || $serial_check->data != '1337') {
                        $session->set('validation_status', '0', self::$session_namespace);
                        $session->set('validated_serial', '0', self::$session_namespace);
                        $return_value = -4;
                    }
                    if ($serial_check->success == 1 && $serial_check->data == '1337' AND $return_value == 0) {
                        $session->set('validation_status', '1337', self::$session_namespace);
                        $session->set('validated_serial', $serial, self::$session_namespace);
                        $return_value = true;
                    }
                }
            }
        }

		if($debug)
		{
            echo "========================================================================<br>";
            echo "URL: $url_check <br>";
			echo "checkValidationStatus() return value: ". $return_value ."<br>";
		}

        return $return_value;
    }
	
    public static function generateHash()
    {
        $date  = new JDate('now');
        $today = $date->format('Y-m-d');
        $salt  = '7n^jYXfcZz1l6Oq^FRH6GHQg@EN_GpZQ5Z&(N8tA';
        return urlencode(crypt($today, $salt));
    }
    
    public static function reset() 
    {
    	$session = JFactory::getSession();
            $session->set('validation_status', '0', self::$session_namespace);
			$session->set('validated_serial', '0', self::$session_namespace);
    }
}