<?php
/**
 * @package    AGMedia Library
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Apr-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');


/**
 * AgmLib library.
 * @since 1.0.0
 */
class AgmLibWicked
{

    private static $_wickedTeamElementName                  = 'com_wickedteam';
    private static $_wickedTeamIsInstalled                  = FALSE;
    private static $_wickedTeamIsInstalledAlreadyChecked    = FALSE;


    /**
     * PHP Function um zu prüfen ob WickedTeam installiert ist
     * @param $force_check bool Soll auf jeden Fall über eine MYSQL Query eine Abfrage erfolgen
     * @return self::$_wickedTeamIsInstalle bool
     */
    public static function isInstalled($force_check = FALSE)
    {
        //Überprüfung nur einmal durchführen, danach das Ergebnis speichern
        if(!self::$_wickedTeamIsInstalledAlreadyChecked OR $force_check) {
            $db = JFactory::getDbo();
            self::$_wickedTeamIsInstalled = FALSE; //Reset state

            //Array mit einer Liste von allen Datenbanktabellen
            $query = $db->getQuery(true);
            $query
                ->select('*')
                ->from('#__extensions')
                ->where('element LIKE "%'. self::$_wickedTeamElementName .'%"');

            $db->setQuery($query);
            $result = $db->loadAssoc();

            if(!empty($result['extension_id'])) {
                self::$_wickedTeamIsInstalled = TRUE; //Set state
            }

            self::$_wickedTeamIsInstalledAlreadyChecked = TRUE; //Set state
        }

        return self::$_wickedTeamIsInstalled;
    }

	/**
	 * Funktion um die WickedUserID zu bekommen wenn ein verknüpfter Joomla User gefunden wird
	 * @param $joomla_userID
	 * @return wicked_userID
	 */
	public static function getWickedUserIdByJoomlaUserId($joomla_userID) {
		if(empty($joomla_userID)) return false;

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query
			->select('id as wicked_userID')
			->from($db->quoteName('#__wickedteam_members'))
			->where('user_id = ' . $db->escape($joomla_userID));
		$db->setQuery($query);
		$result = $db->loadAssoc();

		if($result) {
			return $result['wicked_userID'];
		} else {
			return -1;
		}
	}

	/**
	 * Funktion um die WickedUserID zu bekommen wenn ein verknüpfter Joomla User gefunden wird
	 * @param $wicked_userID
	 * @return $joomla_userID
	 */
	public static function getJoomlaUserIdByWickedUserId($wicked_userID) {
		if(empty($wicked_userID)) return false;

		$localDebug = false;

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query
			->select('user_id as joomla_userID')
			->from($db->quoteName('#__wickedteam_members'))
			->where('id = ' . $db->escape($wicked_userID));
		$db->setQuery($query);
		$result = $db->loadAssoc();


		if($localDebug) {
			echo "-------------- Function getJoomlaUserIdByWickedUserId(wicked_userID) ---------------------------<br>";
			echo "input wicked_userID: ". $wicked_userID ."<br>";
			echo $query->dump();
			echo "Result:<pre>";
			print_r($result);
			echo "</pre><br>";
			echo "### END OF FUNCTION ###<br><br>";
		}

		if($result) {
			if($result['joomla_userID'] > 0) {
				return $result['joomla_userID'];
			} else {
				return -1;
			}

		} else {
			return -1;
		}
	}

}