var RSFirewallPassword = {
	userOptions: [],
	addEvent: function(el, ev, func) {
		// el - element
		// ev - event
		// func - function to trigger
		
		if (typeof jQuery != 'undefined') {
			// jQuery is available
			if (ev == 'load') {
				jQuery(document).ready(func);
			} else if (ev == 'keyup') {
				jQuery(el).keyup(func);
			}
		} else {
			// no library is available, try adding manually
			if (el.addEventListener) {
				el.addEventListener(ev, func, false);
			} else if (el.attachEvent) {
				el.attachEvent('on' + ev, func);
			} else {
				if (ev == 'load') {
					el.onload = func;
				} else if (ev == 'keyup') {
					el.onkeyup = func;
				}
			}
		}
	},
	getEl: function(el) {
		return document.getElementsByName('jform[' + el + ']')[0];
	}
};

RSFirewallPassword.addEvent(window, 'load', function() {
	var field = RSFirewallPassword.getEl('password');
	
	var parent = field.parentNode;
	var container = document.createElement('p');
	parent.appendChild(container);
	
	RSFirewallPassword.addEvent(field, 'keyup', function() {
        var minLength       = parseInt(RSFirewallPassword.userOptions.minLength);
        var minIntegers     = parseInt(RSFirewallPassword.userOptions.minIntegers);
        var minSymbols      = parseInt(RSFirewallPassword.userOptions.minSymbols);
        var minUppercase    = parseInt(RSFirewallPassword.userOptions.minUppercase);
        var minLowercase    = parseInt(RSFirewallPassword.userOptions.minLowercase);
        var password		= field.value;
        var match;

        container.innerHTML = '';

        var messages = [];

        // Minimum length
        if (minLength > 0 && password.length < minLength) {
            messages.push(Joomla.JText._('COM_RSFIREWALL_PASSWORD_MIN_LENGTH').replace('%d', minLength));
        }

        // Minimum integers
        match = password.match(/[0-9]/g) || [];
        if (minIntegers > 0 && match.length < minIntegers) {
            messages.push(Joomla.JText._('COM_RSFIREWALL_PASSWORD_MIN_INTEGERS').replace('%d', minIntegers));
        }

        // Minimum symbols
        match = password.match(/[^a-zA-Z0-9_]/g) || [];
        if (minSymbols > 0 && match.length < minSymbols) {
            messages.push(Joomla.JText._('COM_RSFIREWALL_PASSWORD_MIN_SYMBOLS').replace('%d', minSymbols));
        }

        // Minimum uppercase
        match = password.match(/[A-Z]/g) || [];
        if (minUppercase > 0 && match.length < minUppercase) {
            messages.push(Joomla.JText._('COM_RSFIREWALL_PASSWORD_MIN_UPPERCASE').replace('%d', minUppercase));
        }

		// Minimum lowercase
		match = password.match(/[a-z]/g) || [];
		if (minLowercase > 0 && match.length < minLowercase) {
			messages.push(Joomla.JText._('COM_RSFIREWALL_PASSWORD_MIN_LOWERCASE').replace('%d', minLowercase));
		}

        if (messages.length > 0) {
            container.innerHTML = messages.join('<br />');
        }
	});
});