<?php
/**
 *	@package		Sendinblue
 *	@subpackage		subscription form module
 *	@version		1.0.1
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die;



/**
 * Helper for mod_sendinblueform
 *
 * @since  1.0.0
 */
class ModSendinblueformHelper
{
	
	static $form = null;
	
	/**
	 * Get data for form
	 *
	 */
	public static function getFormData($id = null) {
		$db = JFactory::getDbo();
		$query = 'SELECT * FROM #__sendinblue_subscription_form WHERE id = ' . $id . ' AND `published` = 1'; 
		$db->setQuery($query);
		$formData = $db->loadObject();
		return $formData;		
	}
	
	/**
	 * Get form
	 *
	 */
	public static function getForm($blocks, $moduleid) {
		self::$form = new JForm('sibform'.$moduleid);
		$formloaded = self::$form->loadFile(__DIR__ . '/sibsform.xml');
		

		// $xml = '<fieldset name="custom_fields">';
		// //$xml .= '<field name="' . $field->name . '" type="' . $field->type . '" label="' . $field->label . '" description="' . $field->desc . '" />';
		// $xml .= '<field name="tf" type="textarea" label="tf lab" description="tf des" />';        
        // $xml .= '</fieldset>';
		// $element = new SimpleXMLElement($xml);
        // self::$form->setField($element);
        //$form->setFieldAttribute('somefield', 'required', 'false');
		
		

		$attributes = array( 'label', 'input?',
			'multiple', 'name', 'id', 'hint', 'class', 'description', 'labelclass', 'onchange', 'onclick', 'validate', 
			'pattern', 'validationtext', 'default',
			'required', 'disabled', 'readonly', 'autofocus', 'hidden', 'autocomplete', 'spellcheck', 'translateHint', 'translateLabel',
			'translate_label', 'translateDescription', 'translate_description', 'size', 'showon');


		// convention: block = fieldset - it will be easdy to customise styling 
		foreach ($blocks as $key => $item) {
			if ($item->blockvisible == '1') {

				$name= 'sendinblueform-' . $moduleid . '-' . $key;

				switch ($item->blocktypeid) {
					case 'editor':
						break;
					case 'email':
						self::addField($key, $name, 'email');
						break;
					case 'sms': // not implemeted in v 1.0.13
						self::addField($key, $name, 'text');
						break;
					case 'attribglobal': // not implemeted in v 1.0.13
						self::addField($key, $name, 'text');
						self::$form->setFieldAttribute($name, 'readonly', true);
						$value = 'testing value'; 
						self::$form->setValue($name, null, $value);
						break;
					case 'attribnormaltext':
						self::addField($key, $name, 'text');
						break;
					case 'attribnormalnumber':
						self::addField($key, $name, 'text');
						break;
					case 'attribnormaldate':
						self::addField($key, $name, 'calendar');
						break;
					case 'attribnormalbool':
						self::addField($key, $name, 'checkbox');
						break;
					case 'attribcategorysingle':
						if ($item->blockattribcategorysingledisplay == '1') { $type = 'radio'; } else { $type = 'list'; }
						self::addField($key, $name, $type);
						$optionsJson = self::getFieldOptions($item->blockattribcategoryattribid);
						if ($optionsJson) {
							$fld = self::$form->getField($name);
							$options = json_decode($optionsJson);
							foreach ($options as $option) { $fld->addOption($option->label, array('value' => $option->value)); }
						}
						break;
					case 'attribcategorymulti': // not implemeted in v 1.0.13
						// if ($item->blockattribcategorymultidisplay == '1') { $type = 'radio'; } else { $type = 'list'; } 
						self::addField($key, $name, 'list');
						$optionsJson = self::getFieldOptions($item->blockattribcategoryattribid);
						if ($optionsJson) {
							$fld = self::$form->getField($name);
							$options = json_decode($optionsJson);
							foreach ($options as $option) { $fld->addOption($option->label, array('value' => $option->value)); }
						}
						self::$form->setFieldAttribute($name, 'multiple', true); 
						break;
					case 'divider':
						break;
					case 'optin':
						self::addField($key, $name, 'checkbox');
						break;
					case 'captcha':
						self::addFieldFull($key, $name, 'captcha', 'MOD_SENDINBLUEFORM_CAPTCHA', '', 'captcha');
						break;
					
					default:
						
						break;
				}
				// label  
				if ($item->blocktypeattribshowlabel == '1') {
					if (trim($item->blocktypeattriblabel) != '') {
						self::$form->setFieldAttribute($name, 'label', $item->blocktypeattriblabel);
					} else { //  fall back to block or attrib name
						$labelvar = '';
						switch ($item->blocktypeid) {
							case 'editor':
							case 'email':
							case 'sms':
							case 'divider':
							case 'optin':
								$labelvar = 'blocktypeid';
								break;
							case 'attribglobal':
								$labelvar = 'blockattribglobalattribid'; break;
							case 'attribnormaltext':
								$labelvar = 'blockattribnormaltextattribid'; break;
							case 'attribnormalnumber':
								$labelvar = 'blockattribnormalnumberattribid'; break;
							case 'attribnormaldate':
								$labelvar = 'blockattribnormaldateattribid'; break;
							case 'attribnormalbool':
								$labelvar = 'blockattribnormalboolattribid'; break;
							case 'attribcategorysingle':
								$labelvar = 'blockattribcategoryattribid'; break;
							case 'attribcategorymulti':
								$labelvar = 'blockattribcategoryattribid'; break;
								break;
							case 'captcha':
							default:
								break;
						}
						// get data from Sib server and fall back to attrib name
						if ($labelvar != '') {
							$attribTitle = $item->{$labelvar};
							self::$form->setFieldAttribute($name, 'label', ucfirst(strtolower($attribTitle)));
						}
					}
				} else {
					self::$form->setFieldAttribute($name, 'label', null);
					self::$form->setFieldAttribute($name, 'labelclass', 'hidelabel'); // 					
				}
					
				// required
				if ($item->blockattribrequired == '1') { self::$form->setFieldAttribute($name, 'required', true); } else { self::$form->setFieldAttribute($name, 'required', false); }
				// hint
				if ($item->blocktypeattribshowhint == '1') { self::$form->setFieldAttribute($name, 'hint', $item->blocktypeattribhint); } else { self::$form->setFieldAttribute($name, 'hint', ''); }
				// control class
				if ($item->blockcontrolclass != '') { self::$form->setFieldAttribute($name, 'class', $item->blockcontrolclass); }
			}
		}
		
		return self::$form;
	}

	private static function getFieldOptions($attribid) {
		$db = JFactory::getDbo();
		$query = 'SELECT attribenumerationsubform FROM #__sendinblue_attribute WHERE `attribname` = "' . $attribid . '"';
		$db->setQuery($query);
		if (!($enum = $db->loadResult())) {
			// log
			return false;
		}
		return $enum;
	}

	
	private static function addField($fieldsetname, $fieldname, $type) {
		$xml = '';
		$xml .= '<fieldset name="' . $fieldsetname . '">';
		$xml .= '<field name="'. $fieldname .'" type="' . $type .'" />';
        $xml .= '</fieldset>';
		$element = new SimpleXMLElement($xml);
		self::$form->setField($element);
	}
	
	private static function addFieldFull($fieldsetname, $fieldname, $type, $label = '', $desc = '', $validate = '') {
		$xml = '';
		$xml .= '<fieldset name="' . $fieldsetname . '">';
		$xml .= '<field name="'. $fieldname .'" type="' . $type .'" label="' . $label .'" description="' . $desc .'" validate="' . $validate .'" />';
        $xml .= '</fieldset>';
		$element = new SimpleXMLElement($xml);
		self::$form->setField($element);
	}
	
}
