<?php
/**
 *	@package		Sendinblue
 *	@subpackage		subscription form module
 *	@version		1.0.1
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

// Include the sendinblueform functions only once
JLoader::register('ModSendinblueformHelper', __DIR__ . '/helper.php');
$document = JFactory::getDocument();
$document->addStyleSheet('modules/mod_sendinblueform/mod_sendinblueform.css');

$formid = $params->get('subscriptionformid', '0');
if ( ($buttonlabel = trim($params->get('buttonlabel', ''))) == '') { $buttonlabel = JText::_('MOD_SENDINBLUEFORM_SUBMIT'); }


if ($formid != '0') {
	$formData = ModSendinblueformHelper::getFormData($formid);
}
if ($formData) {
	$blocks = ArrayHelper::fromObject(json_decode($formData->blocksubform), false);
	$form = ModSendinblueformHelper::getForm($blocks, $module->id);	
} else {
	return; 
}

// Stay on the same page
$return           = base64_encode(JUri::getInstance()->toString());

$layout           = $params->get('layout', 'default');

require JModuleHelper::getLayoutPath('mod_sendinblueform', $layout);
