<?php
/**
 *	@package		Sendinblue
 *	@subpackage		subscription form module
 *	@version		1.0.1
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die;

JHtml::_('stylesheet', 'mod_sendinblueform/mod_sendinblueform.css', array('version' => 'auto', 'relative' => true));
JHtml::_('behavior.formvalidator');
JHtml::_('behavior.keepalive');
JHtml::_('bootstrap.tooltip');
?>


<form action="<?php echo JRoute::_('index.php', true, $params->get('usesecure', 0)); ?>" method="post" id="sendinblueform-form" class="form-inline">
	<?php if ($params->get('pretext')) : ?>
		<div class="pretext">
			<p><?php echo $params->get('pretext'); ?></p>
		</div>
	<?php endif; ?>
	
	<?php
	
		$blockHtml = array();
	 
		foreach ($blocks as $key => $item) {
			if ($item->blockvisible == '1') {
				
				$class = 'sendinblueform-block';
				
				$html = '';
				switch ($item->blocktypeid) {
					case 'editor':
						$html .= $item->blocktypeeditortext;  // here could be invalid html 
						break;
					case 'email':
						$html .= $form->renderFieldset($key);
						break;
					case 'sms':
						$html .= $form->renderFieldset($key);
						break;
					case 'attribglobal':
						$html .= $form->renderFieldset($key);
						break;
					case 'attribnormaltext':
						$html .= $form->renderFieldset($key);
						break;
					case 'attribnormalnumber':
						$html .= $form->renderFieldset($key);
						break;
					case 'attribnormaldate':
						$html .= $form->renderFieldset($key);
						break;
					case 'attribnormalbool':
						$html .= $form->renderFieldset($key);
						break;
					case 'attribcategorysingle':
						$html .= $form->renderFieldset($key);
						break;
					case 'attribcategorymulti':
						$html .= $form->renderFieldset($key);
						break;
					case 'divider':
						$html .= '<div class="sendinblueform-divider"></div>';
						break;
					case 'optin':
						$html .= $form->renderFieldset($key);
						break;
					case 'captcha':
						$html .= $form->renderFieldset($key);
						break;
					default:
						break;
				}
				
				if ( $html != '' && $item->blocktypeattribshowhelp == '1' && trim($item->blocktypeattribhelp != '') ) {
					$html .= '<div class="' . $class . '-help help-block">' . $item->blocktypeattribhelp . '</div>';
				}
				// if ($html != '') { $blockHtml[] = '<div class="form-horizontal row-fluid ' . $class . ' ' . $item->blockclass . '">' . $html . '</div>'; }
				if (isset($item->blockstyle) && $item->blockstyle != '') { $style = ' style="' . $item->blockstyle .'"'; } else { $style = ''; }
 				if ($html != '') { $blockHtml[] = '<div class=" ' . $class . ' ' . $item->blockclass . '" ' . $style  . '>' . $html . '</div>'; }	
			}
		}
	
	// if there is a need now you can process plugins on $blockHtml array
	echo implode('', $blockHtml);
	?>
		
	<div id="form-sendinblueform-submit" class="control-group">
		<div class="controls">
			<button type="submit" tabindex="0" name="Submit" class="btn btn-primary sendinblueform-button"><?php echo $buttonlabel; ?></button>
		</div>
	</div>

	<input type="hidden" name="option" value="com_sendinblue" />
	<input type="hidden" name="task" value="subscription.subscribe" />
	<input type="hidden" name="return" value="<?php echo $return; ?>" />
	<?php echo JHtml::_('form.token'); ?>
	
	
	<?php if ($params->get('posttext')) : ?>
		<div class="posttext">
			<p><?php echo $params->get('posttext'); ?></p>
		</div>
	<?php endif; ?>
</form>
