<?php
/**
 * @package    AGMedia library loader
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Apr-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

jimport('joomla.filesystem.folder');

/**
 * System Plugin.
 *
 * @package    AgmLibLoader
 * @subpackage Plugin
 */
class PlgSystemAgmLibLoader extends JPlugin
{
   /**
    * Constructor
    *
    * @param object $subject The object to observe
    * @param array  $config  An array that holds the plugin configuration
    */
   public function __construct(& $subject, $config)
   {
      parent::__construct($subject, $config);
   }

   /**
    * Do something onAfterInitialise
    */
   public function onAfterInitialise()
   {
      if(JFolder::exists(JPATH_LIBRARIES . '/agmlib') AND !defined('AGMLIB_INCLUDED')) {
         JLoader::registerPrefix('AgmLib', JPATH_LIBRARIES . '/agmlib');
         define('AGMLIB_INCLUDED', '1');
      }
   }
}
