<?php
/**
* @package RSform!Pro
* @copyright (C) 2007-2019 www.rsjoomla.com
* @license GPL, http://www.gnu.org/copyleft/gpl.html
*/

defined('_JEXEC') or die;

define('RSFORM_FIELD_JOOMLA_CAPTCHA', 2525);

class plgSystemRsfpjoomlacaptcha extends JPlugin
{
	protected $autoloadLanguage = true;
	
	// get the available captchas
	public function onRsformBackendGetAvailableCaptchas()
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->qn('element', 'value'))
			  ->select($db->qn('name', 'text'))
			  ->from($db->qn('#__extensions'))
			  ->where($db->qn('folder').'='.$db->q('captcha'))
			  ->where($db->qn('enabled').'='.$db->q(1))
			  ->order($db->qn('ordering').' ASC');
		
		$db->setQuery($query);
		$plugins = $db->loadObjectList();
		
		$availablePlugins = array('joomla_default|joomla_default_captcha');
		if (!empty($plugins))
		{
			$lang = JFactory::getLanguage();
			foreach ($plugins as $plugin)
			{
				$extension  = 'plg_captcha_' . $plugin->value;
				$source 	= JPATH_PLUGINS . '/captcha/' . $plugin->value;

				$lang->load($extension . '.sys', JPATH_ADMINISTRATOR, null, false, true) ||	$lang->load($extension . '.sys', $source, null, false, true);
				
				$availablePlugins[] = $plugin->value . '|' . JText::_($plugin->text);
			}
		}
		
		return implode("\n", $availablePlugins);
	}

	public function onRsformBackendAfterCreateFieldGroups(&$fieldGroups, $self)
	{
		$formId = JFactory::getApplication()->input->getInt('formId');
		$exists = RSFormProHelper::componentExists($formId, RSFORM_FIELD_JOOMLA_CAPTCHA);

		$fieldGroups['captcha']->fields[] = (object) array(
			'id' 	=> RSFORM_FIELD_JOOMLA_CAPTCHA,
			'name' 	=> JText::_('RSFP_JOOMLA_CAPTCHA_LABEL'),
			'icon'  => 'rsficon rsficon-spinner9',
			'exists' => $exists ? $exists[0] : false
		);
	}
}