<?php
 /**
 *	@package		Sendinblue marketing automation plug-in
 *	@subpackage		SendinblueMA.php
 *	@version		1.0.2
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */

 
 
// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

class plgSystemSendInBlueMA extends JPlugin
{
	protected $autoloadLanguage = true;
	
    function onAfterRender()
    {
        $app = JFactory::getApplication();
        if ($app->isAdmin()) { return; }

        $code = $this->params->get('code', '');
		$chat_enabled = $this->params->get('chat_enabled', '0');
		$chat_custom_messages_enabled = $this->params->get('chat_custom_messages_enabled', '0');
		$welcome_message = $this->params->get('welcome_message', '');
		$offline_message = $this->params->get('offline_message', '');
    
		// email_id
		$inputCookie  = JFactory::getApplication()->input->cookie; // Get input cookie object		
		$user = JFactory::getUser(); 
		if ($user->id == 0) {
			$email_id = $inputCookie->get($name = 'email_id', ''); // try to get from cookies
		} else {
			$email_id = $user->email;
			$inputCookie->set('email_id', $email_id, 0);
		}
	    $domain = $this->params->get('emailid', 'auto');
		if (trim($domain) == '') { $domain = 'auto'; }
	
        $javascript = '';
        $buffer = JResponse::getBody();

		$javascript .= '<!-- Sendinblue marketing automation Plugin start -->';
		$javascript .= '<script type="text/javascript">
			(function() {
			    window.sib = { equeue: [], client_key: "' . $code . '" };';
			    /* OPTIONAL: email for identify request*/
		if ($email_id != '') {
			$javascript .= ' window.sib.email_id = "' . $email_id . '";';
		}
		$javascript .= ' window.sib.display_chat = ' . $chat_enabled . ';';
		if ( (int) $chat_enabled == 1) {
			if ( (int) $chat_custom_messages_enabled == 1) {
				$javascript .= 'window.sib.custom_welcome_message = ' . json_encode($welcome_message) . ';';
				$javascript .= 'window.sib.custom_offline_message = ' . json_encode($offline_message) . ';';
			}
		}
		$javascript .= '
				window.sendinblue = {}; for (var j = ["track", "identify", "trackLink", "page"], i = 0; i < j.length; i++) { (function(k) { window.sendinblue[k] = function() { var arg = Array.prototype.slice.call(arguments); (window.sib[k] || function() { var t = {}; t[k] = arg; window.sib.equeue.push(t);})(arg[0], arg[1], arg[2]);};})(j[i]);}var n = document.createElement("script"),i = document.getElementsByTagName("script")[0]; n.type = "text/javascript", n.id = "sendinblue-js", n.async = !0, n.src = "https://sibautomation.com/sa.js?key=" + window.sib.client_key, i.parentNode.insertBefore(n, i), window.sendinblue.page();
			})();
			</script>';
		$javascript .= '<!-- Sendinblue marketing automation Plugin end -->';

        $buffer = preg_replace("/<\/head>/", "\n\n" . $javascript . "\n\n</head>", $buffer);

        JResponse::setBody($buffer);

        return true;
     }
}
?>